! PRE_PGBOX_LOG -- count the number of labelled ticks

subroutine PRE_PGBOX_LOG_X( xopt, xtick, nxsub,                         &
                            xblc, xtrc, nb_labels )

   character(len=*), intent(in)  :: xopt
   double precision, intent(in)  :: xtick
   integer,          intent(in)  :: nxsub
   double precision, intent(in)  :: xblc, xtrc
   integer,          intent(out) :: nb_labels

   ! See PGBOX.
   !--
   ! 13-Apr-2021 - Creation from PGBOX
   !-----------------------------------------------------------------------

   character*64 :: opt
   logical :: xoptn, xoptm, xopts, xoptl
   logical :: xrange, irange, xoptls, xoptls2, xoptls3
   integer :: i, i1, i2, j, j2, j3
   integer :: nsubx
   double precision :: xint, xint2, xval
   double precision :: a, b, c

   double precision :: v1, v2
   double precision :: ecart, ecart_ratio

   ! Table of logarithms 1..10 (log10)
   double precision :: tab(10), utab(10)
   DATA TAB / 0.000000000000000d0, 0.301029995663981d0,                 &
              0.477121254719662d0, 0.602059991327962d0,                 &
              0.698970004336019d0, 0.778151250383644d0,                 &
              0.845098040014257d0, 0.903089986991944d0,                 &
              0.954242509439325d0, 1.000000000000000d0 /

   xrange(a,b,c) = ( a<b .and. b<c ) .or. ( c<b .and. b<a )
   irange(a,b,c) = ( a<=b .and. b<=c ) .or. ( c<=b .and. b<=a )

   !------ end of declarations -- execution starts hereafter  ------

   ! Decode options.
   call grtoup(opt,xopt)
   xoptl = index(opt,'L') /= 0
   xoptm = index(opt,'M') /= 0
   xoptn = index(opt,'N') /= 0
   xopts = index(opt,'S') /= 0

   !========================= X axis ==================================

   ! Choose X tick intervals.
   ! Major interval: XINT, minor interval: XINT2
   utab(1) = 0.0
   if( xoptl ) then
      xint = sign(1.0d0,xtrc-xblc)
      nsubx = 1
      if( xint > 0.0 ) then
         utab(2:10) = tab(2:10)
      else
         utab(2:10) = 1.0 - tab(2:10)
      end if
   else if( xtick == 0.0 ) then
      xint = max(0.05d0, min(7.0d0*pgxsp(pgid)/pgxlen(pgid), 0.2d0))*(xtrc-xblc)
      xint = pgrnd(xint,nsubx)
   else
      xint = sign(xtick,xtrc-xblc)
      nsubx = max(nxsub,1)
   end if
   if( .not. xopts ) nsubx = 1
   xint2 = xint/nsubx
   xoptls = xoptl .and. xopts .and. (abs(xtrc-xblc)<2.0d0)
   xoptls2 = xoptls .and. (abs(xtrc-xblc)<1.0d0)
   xoptls3 = xoptls2 .and. (abs(xtrc-xblc)<0.5d0)

nb_labels = 0
   ! Write X labels.
   if( xoptn .or. xoptm ) then
      call pgbox1(xblc, xtrc, xint, i1, i2)
      do i = i1, i2
nb_labels = nb_labels + 1
      end do
   end if

   ! Extra X labels for log axes.
   if( xoptls ) then
      call pgbox1(xblc, xtrc, xint2, i1, i2)
      if( xoptls2 ) then
         j2 = 9
         j3 = 1
      else
         j2 = 5
         j3 = 3
      end if
      do i = i1-1, i2
         do j = 2, j2, j3
            xval = (i+utab(j))*xint2
            if( irange(xblc,xval,xtrc) ) then
nb_labels = nb_labels + 1
            end if
         end do
         if( xoptls3 ) then
            do j = 1, 9
               v1 = 10.0d0**((i+utab(j))*xint2)
               v2 = 10.0d0**((i+utab(j+1))*xint2)
               ecart = (i+utab(j+1))*xint2 - (i+utab(j))*xint2
               ecart_ratio = ecart/abs(xtrc-xblc)
               if( ecart_ratio > 0.5d0 ) then
                  !--------------
                  xval = log10( v1 + 0.25d0*(v2-v1) )
                  if( irange(xblc,xval,xtrc) ) then
nb_labels = nb_labels + 1
                  end if
                  !--------------
                  xval = log10( v1 + 0.5d0*(v2-v1) )
                  if( irange(xblc,xval,xtrc) ) then
nb_labels = nb_labels + 1
                  end if
                  !--------------
                  xval = log10( v1 + 0.75d0*(v2-v1) )
                  if( irange(xblc,xval,xtrc) ) then
nb_labels = nb_labels + 1
                  end if
               end if
            end do
         end if
      end do
   end if

end subroutine PRE_PGBOX_LOG_X
!_______________________________________________________________________
!
subroutine PRE_PGBOX_LOG_Y( yopt, ytick, nysub,                         &
                            yblc, ytrc, nb_labels )

   character(len=*), intent(in)  :: yopt
   double precision, intent(in)  :: ytick
   integer,          intent(in)  :: nysub
   double precision, intent(in)  :: yblc, ytrc
   integer,          intent(out) :: nb_labels

   ! See PGBOX.
   !--
   ! 13-Apr-2021 - Creation from PGBOX
   !-----------------------------------------------------------------------

   character*64 :: opt
   logical :: yoptn, yoptm, yopts, yoptl
   logical :: xrange, irange, yoptls, yoptls2, yoptls3
   integer :: i, i1, i2, j, j2, j3
   integer :: nsuby
   double precision :: yint, yint2, yval
   double precision :: a, b, c

   double precision :: v1, v2
   double precision :: ecart, ecart_ratio

   ! Table of logarithms 1..10 (log10)
   double precision :: tab(10), utab(10)
   DATA TAB / 0.000000000000000d0, 0.301029995663981d0,                 &
              0.477121254719662d0, 0.602059991327962d0,                 &
              0.698970004336019d0, 0.778151250383644d0,                 &
              0.845098040014257d0, 0.903089986991944d0,                 &
              0.954242509439325d0, 1.000000000000000d0 /

   xrange(a,b,c) = ( a<b .and. b<c ) .or. ( c<b .and. b<a )
   irange(a,b,c) = ( a<=b .and. b<=c ) .or. ( c<=b .and. b<=a )

   !------ end of declarations -- execution starts hereafter  ------

   ! Decode options.
   call grtoup(opt,yopt)
   yoptl = index(opt,'L') /= 0
   yoptm = index(opt,'M') /= 0
   yoptn = index(opt,'N') /= 0
   yopts = index(opt,'S') /= 0

   !========================= Y axis ==================================

   ! Choose Y tick intervals.
   ! Major interval: YINT, minor interval: YINT2
   utab(1) = 0.0
   if( yoptl ) then
      yint = sign(1.0d0,ytrc-yblc)
      nsuby = 1
      if( yint > 0.0 ) then
         utab(2:10) = tab(2:10)
      else
         utab(2:10) = 1.0 - tab(2:10)
      end if
   else if( ytick == 0.0 ) then
      yint = max(0.05d0, min(7.0d0*pgxsp(pgid)/pgylen(pgid), 0.2d0))*(ytrc-yblc)
      yint = pgrnd(yint,nsuby)
   else
      yint  = sign(ytick,ytrc-yblc)
      nsuby = max(nysub,1)
   end if
   if( .not. yopts ) nsuby = 1
   yint2 = yint/nsuby
   yoptls = yoptl .and. yopts .and. (abs(ytrc-yblc)<2.0d0)
   yoptls2 = yoptls .and. (abs(ytrc-yblc)<1.0d0)
   yoptls3 = yoptls2 .and. (abs(ytrc-yblc)<0.5d0)

nb_labels = 0
   ! Write Y labels.
   if( yoptn .or. yoptm ) then
      call pgbox1(yblc, ytrc, yint, i1, i2)
      do i = i1, i2
nb_labels = nb_labels + 1
      end do
   end if

   ! Extra Y labels for log axes.
   if( yoptls ) then
      call pgbox1(yblc, ytrc, yint2, i1, i2)
      if( yoptls2 ) then
         j2 = 9
         j3 = 1
      else
         j2 = 5
         j3 = 3
      end if
      do i = i1-1, i2
         do j = 2, j2, j3
            yval = (i+utab(j))*yint2
            if( irange(yblc,yval,ytrc) ) then
nb_labels = nb_labels + 1
            end if
         end do
         if( yoptls3 ) then
            do j = 1, 9
               v1 = 10.0d0**((i+utab(j))*yint2)
               v2 = 10.0d0**((i+utab(j+1))*yint2)
               ecart = (i+utab(j+1))*yint2 - (i+utab(j))*yint2
               ecart_ratio = ecart/abs(ytrc-yblc)
               if( ecart_ratio > 0.5d0 ) then
                  !--------------
                  yval = log10( v1 + 0.25d0*(v2-v1) )
                  if( irange(yblc,yval,ytrc) ) then
nb_labels = nb_labels + 1
                  end if
                  !--------------
                  yval = log10( v1 + 0.5d0*(v2-v1) )
                  if( irange(yblc,yval,ytrc) ) then
nb_labels = nb_labels + 1
                  end if
                  !--------------
                  yval = log10( v1 + 0.75d0*(v2-v1) )
                  if( irange(yblc,yval,ytrc) ) then
nb_labels = nb_labels + 1
                  end if
               end if
            end do
         end if
      end do
   end if

end subroutine PRE_PGBOX_LOG_Y
