subroutine pgtricons_ec( xyz, nn, tri, ntri,                            &
                         level_array, n_level, icol_array )

   integer :: nn, ntri
   double precision :: xyz(nn,3), tri(ntri,3)
   integer :: n_level
   double precision :: level_array(n_level)
   integer :: icol_array(n_level)
   !------ API end ------

   ! seul le nom de cette routine ressemble à 'pgcons_ec',
   ! l'algorithme est totalement différent (EC implementation)

   integer :: i, k, icolor, icolor_old, k1, k2, k3
   double precision :: level, z1, z2, z3, coeff
   double precision :: x_beg, y_beg, x_end, y_end
   logical :: begin_ok
   !------ end of declarations -- execution starts hereafter  ------

   if( PRINTING_PDF ) then
      gr_pdf_color_intent = 1 ! Stroke
   end if

   icolor_old = -1

   do i = 1, n_level

      ! plotting each level curve
      level = level_array(i)
      icolor = icol_array(i)

      do k = 1, ntri

         k1 = tri(k,1)
         k2 = tri(k,2)
         k3 = tri(k,3)

         z1 = xyz(k1,3)
         z2 = xyz(k2,3)
         z3 = xyz(k3,3)

         if( level < min(z1,z2,z3) .or. max(z1,z2,z3) < level ) then
            ! nothing to plot
            cycle
         end if

         if( z1 == level .and. z2 == level .and. z3 == level ) then
            ! extreme case : the three vertices has a value which
            !                is equal to 'level'
!### pas du tout logique de faire ça : pas cohérent avec la manière
!    d'envisager les choses en maillage quadrangulaire (cf. msContour)
            x_beg = xyz(k1,1)
            y_beg = xyz(k1,2)
            x_end = ( xyz(k2,1) + xyz(k3,1) ) / 2
            y_end = ( xyz(k2,2) + xyz(k3,2) ) / 2
         else if( z1 == level .and. z2 == level ) then
            x_beg = xyz(k1,1)
            y_beg = xyz(k1,2)
            x_end = xyz(k2,1)
            y_end = xyz(k2,2)
         else if( z2 == level .and. z3 == level ) then
            x_beg = xyz(k2,1)
            y_beg = xyz(k2,2)
            x_end = xyz(k3,1)
            y_end = xyz(k3,2)
         else if( z3 == level .and. z1 == level ) then
            x_beg = xyz(k3,1)
            y_beg = xyz(k3,2)
            x_end = xyz(k1,1)
            y_end = xyz(k1,2)
         else
            ! general case : we must linearly interpolate to
            !                find end-points of the segment
            begin_ok = .false.
            if( min(z1,z2) <= level .and. level <= max(z1,z2) ) then
               coeff = (z1-level)/(z1-z2) ! coeff in [0,1]
               x_beg = (1-coeff)*xyz(k1,1) + coeff*xyz(k2,1)
               y_beg = (1-coeff)*xyz(k1,2) + coeff*xyz(k2,2)
               begin_ok = .true.
            end if
            if( min(z2,z3) <= level .and. level <= max(z2,z3) ) then
               coeff = (z2-level)/(z2-z3) ! coeff in [0,1]
               if( begin_ok ) then
                  x_end = (1-coeff)*xyz(k2,1) + coeff*xyz(k3,1)
                  y_end = (1-coeff)*xyz(k2,2) + coeff*xyz(k3,2)
               else
                  x_beg = (1-coeff)*xyz(k2,1) + coeff*xyz(k3,1)
                  y_beg = (1-coeff)*xyz(k2,2) + coeff*xyz(k3,2)
               end if
            end if
            if( min(z3,z1) <= level .and. level <= max(z3,z1) ) then
               coeff = (z3-level)/(z3-z1) ! coeff in [0,1]
               x_end = (1-coeff)*xyz(k3,1) + coeff*xyz(k1,1)
               y_end = (1-coeff)*xyz(k3,2) + coeff*xyz(k1,2)
            end if
         end if

         ! select color only for a new one
         if( icolor /= icolor_old ) then
            call grsci(icolor) ! set color index
         end if
         icolor_old = icolor

         ! ok, plotting the linear segment
         call pgline( 2, [x_beg,x_end], [y_beg,y_end] )

      end do

   end do

end subroutine
