! PGTRICNSC_EC -- contour map of a 2D data array (triangular case) (EC)

subroutine pgtricnsc_ec( xy, z, nn,                                     &
                         level_array, n_level,                          &
                         face_n, face_tri, tri_n, tri_f )

   integer,          intent(in) :: nn
   double precision, intent(in) :: xy(nn,2), z(nn)
   integer,          intent(in) :: n_level
   double precision, intent(in) :: level_array(n_level)
   integer,          intent(in) :: face_n(:,:), face_tri(:,:),          &
                                   tri_n(:,:), tri_f(:,:)
   !------ API end ------

   ! set to TRUE if the corresponding side contains a crossing point.
   logical, allocatable :: flags_face(:)
   integer :: nf, n1, n2, t1, status, f1
   double precision :: orient

   integer :: i, k, k1, k2, k3, n_points
   double precision :: level, z1, z2, z3, coeff
   double precision :: x_beg, y_beg, x_end, y_end
   logical :: begin_ok
   integer :: continuation

   ! Contour found. We have to check this to add a record to XY(:,:)
   ! even if the level is out-of-range (in this later case, nb of pts
   ! will zero).
   logical :: contour_found

   !------ end of declarations -- execution starts hereafter  ------

   ! Get number of faces
   nf = size(face_n,1)
   allocate( flags_face(nf) )

   do i = 1, n_level

      contour_found = .false.

      ! Compute each level curve
      level = level_array(i)
!!print "(A,I0,A,ES10.3)", "pgtricnsc_ec: processing level #", i, &
!!                         " with val. ", level

      ! Initialize the flag array
      do k = 1, nf
         n1 = face_n(k,1)
         n2 = face_n(k,2)
         z1 = z(n1)
         z2 = z(n2)
         if( xrange(level,z1,z2) ) then
            flags_face(k) = .true.
         else
            flags_face(k) = .false.
         end if
      end do

      ! Go first through the domain edge only.
      ! (enter the domain only if the higher value is on the left)
      do k = 1, nf
         if( flags_face(k) .and. face_tri(k,2)<=0 ) then
            t1 = face_tri(k,1)
            n1 = face_n(k,1)
            n2 = face_n(k,2)
            ! search for {n1,n2} in the table tri_n, and deduce orientation
            ! of (n1,n2)
            if( ( tri_n(t1,1)==n1 .and. tri_n(t1,2)==n2 ) .or.          &
                ( tri_n(t1,2)==n1 .and. tri_n(t1,3)==n2 ) .or.          &
                ( tri_n(t1,3)==n1 .and. tri_n(t1,1)==n2 ) ) then
               orient = 1.0d0
            else
               orient = -1.0d0
            end if
            z1 = z(n1)
            if( (z1 - level)*orient >= 0 ) then
               continuation = 0
               f1 = k
               contour_found = .true.
!!print *, "  *** One contour from the edge."
               call follow_path_edge( f1, t1, status )
               if( status /= 0 ) return
            end if

         end if
      end do

      ! Then go inside the domain
      do k = 1, nf
         if( flags_face(k) ) then
            t1 = face_tri(k,1)
            n1 = face_n(k,1)
            n2 = face_n(k,2)
            ! search for {n1,n2} in the table tri_n, and deduce orientation
            ! of (n1,n2)
            if( ( tri_n(t1,1)==n1 .and. tri_n(t1,2)==n2 ) .or.          &
                ( tri_n(t1,2)==n1 .and. tri_n(t1,3)==n2 ) .or.          &
                ( tri_n(t1,3)==n1 .and. tri_n(t1,1)==n2 ) ) then
               orient = 1.0d0
            else
               orient = -1.0d0
            end if
            z1 = z(n1)
            if( (z1 - level)*orient > 0 ) then
               continuation = 0
               f1 = k
               contour_found = .true.
!!print *, "  *** One contour inside."
               call follow_path_inside( f1, t1, status )
               if( status /= 0 ) return
            end if

         end if
      end do

      if( .not. contour_found ) then
!!print *, "  *** No contour for this level"
         if( .not. allocated(XY_cont) ) then
            XY_cont_size = 100
            allocate( XY_cont(2,XY_cont_size) )
            XY_cont_current_pos = 0
         else
            ! si besoin, on finalise le contour courant
            if( .not. XY_contour_finalized ) then
               n_points = XY_cont_current_pos - XY_cont_current_beg
!!print "(A,I0,A,I0)", "  finaliz. of the prev. cont.: npt = ", n_points, &
!!                     " added in XY_cont at pos. ", XY_cont_current_beg
               XY_cont(2,XY_cont_current_beg) = n_points
               XY_contour_finalized = .true.
            end if
         end if
         ! new (empty) contour
         XY_cont_nb_cont = XY_cont_nb_cont + 1
         XY_cont_current_pos = XY_cont_current_pos + 1
         XY_cont(1,XY_cont_current_pos) = level
         XY_cont(2,XY_cont_current_pos) = 0
         XY_contour_finalized = .true.
      end if

   end do

contains
!_______________________________________________________________________
!
      logical function xrange( p, p1, p2 )

         ! The function XRANGE decides whether a contour at level P
         ! crosses the line between two points with values P1 and P2.
         ! It is important that a contour cannot cross a line with equal
         ! endpoints.

         double precision, intent(in) :: p, p1, p2

         !------ end of declarations -- execution starts hereafter  ------

         xrange = ( p > min(p1,p2) ) .and. ( p <= max(p1,p2) )          &
                    .and. ( p1 /= p2 )
      end function xrange
!_______________________________________________________________________
!
      subroutine follow_path_edge( f1, t, status )

         integer :: f1, t
         integer :: status
         !------ API end ------

         ! On construit un contour à partir d'une face de frontière
         !---------------

         integer :: f2, i, t2

         !------ end of declarations -- execution starts hereafter  ------

         status = 0

         ! entering in the triangle 't' and face 'f1'...
!!print *, "pgtricnsc_ec.f90: line 138: follow_path_edge:"
!!print *, " -> begin of a new contour from boundary, from face #", f1
!!pause

         do
            ! this face is now consumed
            flags_face(f1) = .false.

            ! determine f2, the other face containing a crossing point
            i = 1
            f2 = tri_f(t,i)
            if( f2 == f1 ) then
               i = i + 1
               f2 = tri_f(t,i)
            end if

            if( flags_face(f2) ) then
               go to 10
            else
               i = i + 1
               f2 = tri_f(t,i)
               if( f2 == f1 ) then
                  if( i == 3 ) then
                     print "(/,A)", "follow_path: internal error ***"
                     print "(A,I0,A)", "              in triangle ", t,  &
                                       ": cannot find the other face"
                     pause "for debugging purpose only..."
status = 1
return
                     stop
                  else
                     i = i + 1
                     f2 = tri_f(t,i)
                  end if
               end if

               if( flags_face(f2) ) then
                  go to 10
               else
                  if( i == 3 ) then
                     print "(/,A)", "follow_path: internal error ***"
                     print "(A,I0,A)", "              in triangle ", t,  &
                                       ": cannot find the other face"
                     pause "for debugging purpose only..."
status = 1
return
                     stop
                  else
                     i = i + 1
                     f2 = tri_f(t,i)
                  end if
                  if( flags_face(f2) ) then
                     go to 10
                  else
                     print "(/,A)", "follow_path: internal error ***"
                     print "(A,I0,A)", "              in triangle ", t,  &
                                       ": cannot find the other face"
                     pause "for debugging purpose only..."
status = 1
return
                     stop
                  end if
               end if
            end if

 10         continue

            ! drawing one segment inside the triangle 't'
            ! (joining the two crossing points in f1 and f2)

            ! first point (face f1)
            n1 = face_n(f1,1)
            n2 = face_n(f1,2)
            z1 = z(n1)
            z2 = z(n2)
            coeff = (z1-level)/(z1-z2) ! coeff in [0,1]
            x_beg = (1-coeff)*xy(n1,1) + coeff*xy(n2,1)
            y_beg = (1-coeff)*xy(n1,2) + coeff*xy(n2,2)
            ! second point (face f2)
            n1 = face_n(f2,1)
            n2 = face_n(f2,2)
            z1 = z(n1)
            z2 = z(n2)
            coeff = (z1-level)/(z1-z2) ! coeff in [0,1]
            x_end = (1-coeff)*xy(n1,1) + coeff*xy(n2,1)
            y_end = (1-coeff)*xy(n1,2) + coeff*xy(n2,2)
            if( continuation == 0 ) then
               call pg_store_tricontour( continuation, x_beg, y_beg,    &
                                         level, f1 )
               continuation = 1
            end if
            call pg_store_tricontour( continuation, x_end, y_end,       &
                                      level, f2 )
!!print "(2(A,I0),A)", "      other face: ", f2, " (triangle ", t, ")"

            ! check for exit
            t2 = face_tri(f2,2)
            if( t2 <= 0 ) then
               flags_face(f2) = .false.
               ! the domain edge is reached: exit
!!print "(A)", "      domain edge reached. "
               exit
            else if( t2 == t ) then
               t2 = face_tri(f2,1)
            end if

!!print "(A,I0)", " new triangle is ", t2

            ! cycle
            f1 = f2
            t = t2

         end do

      end subroutine follow_path_edge
!_______________________________________________________________________
!
      subroutine follow_path_inside( f1, t, status )

         integer :: f1, t
         integer :: status

         !---------------

         integer :: f2, i, t2
         logical :: first_crossing_point
         double precision :: x_beg_first, y_beg_first

         !------ end of declarations -- execution starts hereafter  ------

         status = 0

         first_crossing_point = .true.

         ! entering in the triangle 't' and face 'f1'...

         do
if( t == 0 ) then
   print "(/,A)", "follow_path_inside: Oh! Aïe, aïe! Something's terribly wrong! t = 0"
   pause
end if
            ! this face is now consumed
            flags_face(f1) = .false.

            ! determine f2, the other face containing a crossing point
            ! (if not found, we will close the contour)
            i = 1
            f2 = tri_f(t,i)
            if( f2 == f1 ) then
               i = i + 1
               f2 = tri_f(t,i)
            end if

            if( flags_face(f2) ) then
               go to 10
            else
               i = i + 1
               f2 = tri_f(t,i)
               if( f2 == f1 ) then
                  if( i == 3 ) then
                     go to 20
                  else
                     i = i + 1
                     f2 = tri_f(t,i)
                  end if
               end if

               if( flags_face(f2) ) then
                  go to 10
               else
                  if( i == 3 ) then
                     go to 20
                  else
                     i = i + 1
                     f2 = tri_f(t,i)
                  end if
                  if( flags_face(f2) ) then
                     go to 10
                  else
                     go to 20
                  end if
               end if
            end if

 10         continue

            ! drawing one segment inside the triangle 't'
            ! (joining the two crossing points in f1 and f2)

            ! first point (face f1)
            n1 = face_n(f1,1)
            n2 = face_n(f1,2)
            z1 = z(n1)
            z2 = z(n2)
            coeff = (z1-level)/(z1-z2) ! coeff in [0,1]
            x_beg = (1-coeff)*xy(n1,1) + coeff*xy(n2,1)
            y_beg = (1-coeff)*xy(n1,2) + coeff*xy(n2,2)
            if( first_crossing_point ) then
               x_beg_first = x_beg
               y_beg_first = y_beg
!!print "(A,2(G0.4,2X))", "*** saving first point : ", x_beg, y_beg
               first_crossing_point = .false.
            end if
            ! second point (face f2)
            n1 = face_n(f2,1)
            n2 = face_n(f2,2)
            z1 = z(n1)
            z2 = z(n2)
            coeff = (z1-level)/(z1-z2) ! coeff in [0,1]
            x_end = (1-coeff)*xy(n1,1) + coeff*xy(n2,1)
            y_end = (1-coeff)*xy(n1,2) + coeff*xy(n2,2)
            if( continuation == 0 ) then
               call pg_store_tricontour( continuation, x_beg, y_beg, level )
               continuation = 1
            end if
            call pg_store_tricontour( continuation, x_end, y_end, level )
!!print "(2(A,I0),A)", "      other face: ", f2, " (triangle ", t, ")"

            ! check for exit
            t2 = face_tri(f2,2)
            if( t2 == t ) then
               t2 = face_tri(f2,1)
            end if

!!print "(A,I0)", " new triangle is ", t2

            ! cycle
            f1 = f2
            t = t2

            cycle

         end do

!!print *, "follow_path_inside: return! so the contour is not closed!"
         return

 20      continue

         ! The contour must be closed. Join the last crossing point
         ! with the first one.
         call pg_store_tricontour( continuation, x_beg_first,           &
                                                 y_beg_first, level )

      end subroutine follow_path_inside
!_______________________________________________________________________
!
end subroutine
