! PGSLICES -- cross-sections through a 2D data array

subroutine PGSLICES( data, ni, nj, i1, i2, j1, j2, x )

   integer,          intent(in) :: ni, nj, i1, i2, j1, j2
   double precision, intent(in) :: data(ni,nj), x(i2-i1+1)

   ! Plot a series of cross-sections through a 2D data array. Each
   ! cross-section is plotted as a hidden colored zone, which may be
   ! covered by other zones.
   !
   ! Arguments:
   !  DATA(NI,NJ) (input): the data array to be plotted.
   !  I1 (input)
   !  I2 (input)  I2 > I1+1 (in order to have at least two points)
   !  J1 (input)
   !  J2 (input): PGSLICES plots a subset of the input array DATA. This
   !              subset is delimited in the first (x) dimension by I1
   !              and I2 and the 2nd (y) by J1 and J2, inclusively.
   !              Note: J2 < J1 is permitted, resulting in a plot with
   !              the cross-sections plotted in reverse Y order.
   !  X  (input): The abscissae of the points to be plotted. That is, X(1)
   !              should be the X value for DATA(I1,J1), and X should
   !              have (I2-I1+1) elements. The program has to assume
   !              that the X value for DATA(x,y) is the same for all y.
   !--
   ! 20-Apr-2020 - From PGHI2D routine. Removed some argument, but changed
   !               the bin (scales) to continuous lines [EC].
   ! 20-Apr-2020 - Removed ylims as dummy argument, since it is a workspace
   !               array. Remove also many arguments, and convert the
   !               graphic action from empty bins to filled, colored
   !               polygons [EC].
   !-----------------------------------------------------------------------

   integer :: inc, i, j, nb_curve, icol
   double precision :: xpts(4), ypts(4), fact

   ! Check arguments.
   if( i2 - i1 + 1 < 2 ) return

   nb_curve = abs(j2-j1) + 1

   call pgbbuf()

   ! Check Y order.
   if( j1 > j2 ) then
      inc = -1
   else
      inc = 1
   end if

   ! Loop through Y values.
   do j = j1, j2, inc

      ! Selecting color from current colormap
      if( nb_curve == 1 ) then
         icol = ( pgmnci(pgid) + pgmxci(pgid) )/2
      else
         fact = (j-min(j1,j2))/(nb_curve-1.0)
         icol = pgmnci(pgid) + fact*(pgmxci(pgid)-pgmnci(pgid))
      end if
      call grsci( icol )

      ! Draw line for this Y value.
      do i = i1, i2-1
         xpts(1) = x(i-i1+1)
         ypts(1) = data(i,j)
         xpts(2) = x(i-i1+2)
         ypts(2) = data(i+1,j)
         xpts(3) = xpts(2)
         ypts(3) = pgyblc(pgid) ! Y-value for the bottom side
         xpts(4) = xpts(1)
         ypts(4) = pgyblc(pgid) ! Y-value for the bottom side
         call pgpoly( 4, xpts, ypts )
      end do

   end do

   call pgebuf()

end subroutine
