! PGOPEN_EC -- open device for graphics (only for X11)

integer function PGOPEN_EC( device, geom, exe_name, win_id, title )

   character(len=*), intent(in) :: device
   integer          :: geom(4)
   character(len=*) :: exe_name
   integer          :: win_id
   character(len=*) :: title
   !------ API end ------

   ! Open a graphics device for MFPLOT output (non X11 devices). If the
   ! device is opened successfully, it becomes the selected device to
   ! which graphics output is directed until another device is selected
   ! with PGSLCT or the device is closed with PGCLOS.
   !
   ! The DEVICE argument is a character constant or variable; its value
   ! should be one of the following: "/XWIN", "/NULL"
   !
   ! Returns:
   !  PGOPEN          : returns either a positive value, the
   !                    identifier of the graphics device for use with
   !                    PGSLCT, or a 0 or negative value indicating an
   !                    error. In the event of error a message is
   !                    written on the standard error unit.
   ! Arguments:
   !  DEVICE  (input) : the 'device specification' for the plot device
   !                    (see above).
   !--
   !       -2004 - Créé à partir de PGOPEN : rajout de plusieurs arguments
   !               pour communiquer avec les drivers. (cf. GROPEN_EC) [EC].
   ! 11-Apr-2015 - Appel à PGSCLP est reporté après PGVSTD, sinon des NaNs
   !               stoppent le programme si l'utilisateur a choisi de le
   !               lancer avec FPE enabled [EC].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   ! 10-Apr-2020 - Interactive prompt with the user is removed [EC].
   ! 11-Apr-2020 - Removed call to grsize: things have already been set in
   !               gropen_ec [EC].
   ! 16-Apr-2020 - Modified to take into account suppression of panels [EC].
   !--------------------------------------------------------------------

   integer :: deftyp, ic1
   integer :: istat

   !------ end of declarations -- execution starts hereafter  ------

   if( len_trim(exe_name) == 0 ) then
      pg_exe_name = ""
   else
      pg_exe_name = exe_name
   end if

   ! Initialize MFPLOT if necessary.
   call pginit

   ! Default device and type
   deftyp = 0

   istat = gropen_ec( deftyp, device, pgid,                             &
                      geom, exe_name, win_id, title )

   ! Failed to open plot file?
   if( istat /= 1 ) then
      pgopen_ec = - 1
      return
   end if

   ! Success: determine device characteristics.
   pgdevs(pgid) = 1
   pgxpin(pgid) = grpxpi(grcide)
   pgypin(pgid) = grpypi(grcide)

   ! 1/4" margins in pixels
   if( X11_XMARGIN == 0 ) then
      X11_XMARGIN = 0.25d0*pgxpin(pgid)
   end if
   if( X11_YMARGIN == 0 ) then
      X11_YMARGIN = 0.25d0*pgypin(pgid)
   end if

   pgblev(pgid) = 0

   ! Set default attributes.
   call grsci(1)
   call grslw(1.0d0)
   call grsls(1)

   call pgsfs(1)
   call pgsah(1, 45.0d0, 0.3d0)
   call pgstbg(-1)
   call pgshs(45.0d0, 1.0d0, 0.0d0)

   ! Set the default range of color indices available for images (16 to
   ! device maximum, if device maximum >= 16; otherwise not possible).
   call grqcol(ic1, pgmxci(pgid))
   pgmnci(pgid) = 16
   if( pgmxci(pgid) < 16 ) pgmxci(pgid) = 0

   ! Select linear transfer function.
   pgitf(pgid) = 0

   pgopen_ec = pgid

end function
