! PGINPUT -- read cursor position (no wait)
!
! idem PGBAND, but no BAND, no waiting (i.e. no event)

integer function PGINPUT( x, y, inside, key )

   double precision, intent(out)           :: x, y
   integer,          intent(out)           :: inside
   character,        intent(out), optional :: key

   ! Read the cursor position and returns it in world coordinates.
   !
   ! Returns:
   !  PGINPUT  : 1 if the call was successful;
   !             0 if the device has no cursor or some other error occurs.
   ! Arguments:
   !  X      : the world x-coordinate of the cursor.
   !  Y      : the world y-coordinate of the cursor.
   !  INSIDE : the character typed by the user;
   !           if the device has no cursor or if some other error occurs,
   !           the value CHAR(0) [ASCII NUL character] is returned.
   !
   !--
   !  7-Feb-2021 - New routine [EC].
   ! 11-Dec-2021 - Added the optional argument 'key'.
   !-----------------------------------------------------------------------

   integer :: i, j, ilenx, ileny

   double precision :: rbuf(1)
   integer :: ibuf(1), lchr
   character(len=1) :: chr

   !------ end of declarations -- execution starts hereafter  ------

   pginput = grcurs_ec( PGID, i, j, inside, ilenx, ileny )

   x = (i - pgxorg(pgid))/pgxscl(pgid)
   y = (j - pgyorg(pgid))/pgyscl(pgid)

   if( present(key) ) then
      call grexec( grgtyp, READ_CURSOR_WITHOUT_WAITING, rbuf, ibuf, chr, lchr )
      key = chr
   end if

end function
