subroutine PGHIST_EC_PRE( n, data, datmin, datmax, nbin,                &
                          nummax, binsiz, num )

   integer :: n
   double precision :: data(*), datmin, datmax
   integer :: nbin
   double precision :: nummax, binsiz, num(*)
   !------ API end ------

   ! Draw a histogram of N values of a variable in array
   ! DATA(1...N) in the range DATMIN to DATMAX using NBIN bins.  Note
   ! that array elements which fall exactly on the boundary between
   ! two bins will be counted in the higher bin rather than the
   ! lower one; and array elements whose value is less than DATMIN or
   ! greater than or equal to DATMAX will not be counted at all.
   !
   ! Arguments:
   !  N      (input)  : the number of data values.
   !  DATA   (input)  : the data values. Note: the dimension of array
   !                    DATA must be greater than or equal to N. The
   !                    first N elements of the array are used.
   !  DATMIN (input)  : the minimum data value for the histogram.
   !  DATMAX (input)  : the maximum data value for the histogram.
   !  NBIN   (input)  : the number of bins to use: the range DATMIN to
   !                    DATMAX is divided into NBIN equal bins and
   !                    the number of DATA values in each bin is
   !                    determined by PGHIST.  NBIN may not exceed 200.
   !  NUMMAX (output) : Max value of NUM(:). Will be used for the 'y' axe
   !  BINSIZ (output) : X size of each bar.
   !  NUM(:) (output) : Array containing the number to be plotted.
   !
   !--
   ! Side effects:
   !
   ! The pen position is changed to (DATMAX,0.0) in world coordinates.
   !--
   !       2004 - Créé à partir de PGHIST : modifié pour pouvoir préparer
   !              les échelles à l'avance. Ici, calcul de différents
   !              tableaux et variables : NUMMAX, BINSIZ, NUM(:) [EC].
   !--------------------------------------------------------------------

   integer :: i, ibin
   !------ end of declarations -- execution starts hereafter  ------

   ! How many values in each bin?

   do ibin = 1, nbin
      num(ibin) = 0
   end do
   do i = 1, n
      ibin = (data(i)-datmin)/(datmax-datmin)*nbin + 1
      if( ibin >= 1 .and. ibin <= nbin ) num(ibin) = num(ibin) + 1
   end do
   nummax = 0
   do ibin = 1, nbin
      nummax = max(nummax,num(ibin))
   end do
   binsiz = (datmax-datmin)/nbin

end subroutine
