! PGHIST_EC -- histogram of unbinned data (modified EC)
!     (mieux mettre en valeur les barres pleines lorsque PGFLAG=2,3)

subroutine PGHIST_EC( datmin, nbin, pgflag, binsiz, num, baseline )

   double precision :: datmin
   integer :: nbin, pgflag
   double precision :: binsiz, num(*), baseline
   !------ API end ------

   ! Draw an histogram of N values of a variable in array DATA(1...N) in the
   ! range DATMIN to DATMAX using NBIN bins. Note that array elements which
   ! fall exactly on the boundary between two bins will be counted in the
   ! higher bin rather than the lower one; and array elements whose value is
   ! less than DATMIN or greater than or equal to DATMAX will not be counted
   ! at all.
   !
   ! Arguments:
   !  DATMIN (input): The minimum data value for the histogram.
   !  NBIN   (input): The number of bins to use: the range DATMIN to DATMAX
   !                  is divided into NBIN equal bins and the number of DATA
   !                  values in each bin is determined by PGHIST.
   !  PGFLAG (input): * If PGFLAG = 1, the histogram is plotted in the current
   !                    window and viewport; if PGFLAG = 0, PGENV is called
   !                    automatically by PGHIST to start a new plot (the
   !                    x-limits of the window will be DATMIN and DATMAX;
   !                    the y-limits will be chosen automatically.
   !                  * IF PGFLAG = 2,3 the histogram will be in the same
   !                    window and viewport but with a filled area style.
   !                  * If PGFLAG = 4,5, same as for PGFLAG = 0,1, but simple
   !                    line drawn as for PGBIN.
   !
   ! For other arguments, see PGHIST_EC_PRE.
   !--
   !        2004 - Created from PGHIST, in order to be able to prepare the
   !               scales in advance, via a call to PGHIST_EC_PRE.
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 28-Mar-2021 - Add the clipping.
   !--------------------------------------------------------------------

   integer :: ibin
   double precision :: cur, prev, xlo, xhi

   !------ end of declarations -- execution starts hereafter  ------

   call pgbbuf()

   call grsls( 1 ) ! continuous line style

   ! Draw Histogram.

   if( pgflag/2 == 0 ) then ! PGFLAG: 0 or 1

      prev = baseline
      xhi = datmin
      call grmova( datmin, baseline )
      do ibin = 1, nbin
         cur = num(ibin)
         xlo = xhi
         xhi = datmin + ibin*binsiz
         if( cur == baseline ) then
            continue
         else if( cur <= prev ) then
            call grmova( xlo, cur )
            call grlina( xhi, cur )
         else
            call grmova( xlo, prev)
            call grlina( xlo, cur )
            call grlina( xhi, cur )
         end if
         call grlina( xhi, baseline )
         prev = cur
      enddo

   else if( pgflag/2 == 1 ) then ! PGFLAG: 2 or 3

      prev = baseline
      xhi = datmin
      do ibin = 1, nbin
         cur = num(ibin)
         xlo = xhi
         xhi = datmin + ibin*binsiz
         if( cur == baseline ) then
            continue
         else
            call grrect( xlo, baseline, xhi, cur, filled=.true. )
         end if
      enddo

      ! Simple thin lines of background color are added between each bin.
      ! This is the best way to avoid irregular bin widths.
      gr_pdf_color_intent = 1 ! Stroke
      call grsci(0)
      xhi = datmin
      call grmova( xhi, baseline )
      do ibin = 1, nbin-1
         cur = max(num(ibin),num(ibin+1))
         xhi = datmin + ibin*binsiz
         if( cur == baseline ) then
            continue
         else
            call grmova( xhi, cur )
         end if
         call grlina( xhi, baseline )
      enddo

   else if( pgflag/2 == 2 ) then ! PGFLAG: 4 or 5

      prev = baseline
      call grmova( datmin, baseline )
      xhi = datmin
      do ibin = 1, nbin
         cur = num(ibin)
         xlo = xhi
         xhi = datmin + ibin*binsiz
         if( cur == baseline .and. prev == baseline ) then
            call grmova( xhi, baseline )
         else
            call grlina( xlo, cur )
            if( cur /= baseline ) then
               call grlina( xhi, cur )
            else
               call grmova( xhi, cur )
            end if
         end if
         prev = cur
      enddo

   end if

   call pgebuf()

end subroutine
