! from PGBOX renamed: PGGRID_EC

subroutine pggrid_ec( xoptl, yoptl, minor_grid, icol_gray )

   logical :: xoptl, yoptl, minor_grid
   integer :: icol_gray
   !------ API end ------

   ! xoptl (resp. yoptl) is true for log scaling.
   !--
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 24-Mar-2020 - Force alignment of dash pattern for all lines.
   ! 11-Jul-2022 - Add missing condition for linear minor grid plotting.
   !-----------------------------------------------------------------------

   integer :: nsubx, nsuby ! computed by pgrnd()

   integer :: i, i1, i2, j
   double precision :: xint, yint, xint2, yint2
   double precision :: xblc, xtrc, yblc, ytrc
   double precision :: xblc_new, xtrc_new, yblc_new, ytrc_new
   double precision :: xval, yval, a, b, c
   logical :: major, irange

   integer :: icol_save

   ! Table of logarithms 1..10 (log10)
   double precision :: tab(10) = [                                      &
                              0.000000000000000d0, 0.301029995663981d0, &
                              0.477121254719662d0, 0.602059991327962d0, &
                              0.698970004336019d0, 0.778151250383644d0, &
                              0.845098040014257d0, 0.903089986991944d0, &
                              0.954242509439325d0, 1.000000000000000d0 ]
   double precision :: utab(10)

   irange(a,b,c) = ( a<=b .and. b<=c ) .or. ( c<=b .and. b<=a )

   !------ end of declarations -- execution starts hereafter  ------

   call pgbbuf()

   call pgqwin( xblc, xtrc, yblc, ytrc )

   if( MF_QR_in_aux_pixmap ) then
      xblc_new = x_left_QR
      xtrc_new = x_right_QR
      yblc_new = y_bottom_QR
      ytrc_new = y_top_QR
   else
      xblc_new = xblc
      xtrc_new = xtrc
      yblc_new = yblc
      ytrc_new = ytrc
   end if

   ! Choose Y tick intervals. Major interval = YINT

   call grqci( icol_save )
   call grsci( icol_gray )

   !========================= X axis ==================================

   ! Choose X tick intervals. Major interval = XINT

   if( xoptl ) then
      xint = sign(1.0d0,xtrc-xblc)
      nsubx = 1
      if( xint > 0.0 ) then
         utab(2:10) = tab(2:10)
      else
         utab(2:10) = 1.0 - tab(2:10)
      end if
   else
      xint = max(0.05d0, min(7.0d0*pgxsp(pgid)/pgxlen(pgid), 0.20))*(xtrc-xblc)
      xint = pgrnd(xint,nsubx)
   end if
   xint2 = xint/nsubx

   ! Draw X grid. (i.e. vertical lines)

   ! dashed line: line style = 2
   call grsls(2)
   call pgbox1(xblc_new, xtrc_new, xint, i1, i2)
   do i = i1, i2
      xval = i*xint
      call grmova( xval, yblc_new )
      call grlina( xval, ytrc_new )
   end do

   if( minor_grid ) then
      ! Choose X tick intervals. Minor interval = XINT2
      ! dotted line: line style = 4
      call grsls(4)
      call pgbox1(xblc_new, xtrc_new, xint2, i1, i2)
      if( xoptl ) then
         ! Log Axes
         do i = i1-1, i2
            do j = 1, 9
               major = mod(i,nsubx)==0 .and. j==1
               xval = (i+utab(j))*xint2
               if( irange(xblc_new,xval,xtrc_new) ) then
                  if( .not. major ) then
                     call grmova( xval, yblc_new )
                     call grlina( xval, ytrc_new )
                  end if
               end if
            end do
         end do
      else
         ! Lin Axes
         do i = i1-1, i2
            if( mod(i,nsubx) /= 0 ) then
               xval = i*xint2
               if( irange(xblc_new,xval,xtrc_new) ) then
                  call grmova( xval, yblc_new )
                  call grlina( xval, ytrc_new )
               end if
            end if
         end do
      end if
   end if

   !========================= Y axis ==================================

   if( yoptl ) then
      yint = sign(1.0d0,ytrc-yblc)
      nsuby = 1
      if( yint > 0.0 ) then
         utab(2:10) = tab(2:10)
      else
         utab(2:10) = 1.0 - tab(2:10)
      end if
   else
      yint = max(0.05d0, min(7.0d0*pgxsp(pgid)/pgylen(pgid), 0.20))*(ytrc-yblc)
      yint = pgrnd(yint,nsuby)
   end if
   yint2 = yint/nsuby

   ! Draw Y grid. (i.e. horizontal lines)

   ! dashed line: line style = 2
   call grsls(2)
   call pgbox1(yblc_new, ytrc_new, yint, i1, i2)
   do i = i1, i2
      yval = i*yint
      call grmova( xblc_new, yval )
      call grlina( xtrc_new, yval )
   end do

   if( minor_grid ) then
      ! Choose Y tick intervals. Minor interval = YINT2
      ! dotted line: line style = 4
      call grsls(4)
      call pgbox1(yblc_new, ytrc_new, yint2, i1, i2)
      if( yoptl ) then
         ! Log Axes
         do i = i1-1, i2
            do j = 1, 9
               major = mod(i,nsuby)==0 .and. j==1
               yval = (i+utab(j))*yint2
               if( irange(yblc_new,yval,ytrc_new) ) then
                  if( .not. major ) then
                     call grmova( xblc_new, yval )
                     call grlina( xtrc_new, yval )
                  end if
               end if
            end do
         end do
      else
         ! Lin Axes
         do i = i1-1, i2
            major = mod(i,nsuby) == 0
            if( .not. major ) then
               yval = i*yint2
               if( irange(yblc_new,yval,ytrc_new) ) then
                  call grmova( xblc_new, yval )
                  call grlina( xtrc_new, yval )
               end if
            end if
         end do
      end if
   end if

   call grsci(icol_save)
   call grsls(1)

   call pgebuf()

end subroutine
