! PGCONTXY_EC -- contour map of a 2D data array (non rectangular)

subroutine PGCONTXY_EC( a, x, y, idim, jdim, c, nc, order )

   integer,          intent(in) :: idim, jdim, nc
   double precision, intent(in) :: a(idim,jdim), c(*)
   double precision, intent(in) :: x(idim,jdim), y(idim,jdim)
   integer,          intent(in) :: order

   ! Compute a contour map of an array. Whereas PGCONT permits only a
   ! linear transformation between the (I,J) grid of the array and the
   ! world coordinate system (x,y), but PGCONX permits any transformation
   ! to be used, the transformation being defined by a user-supplied
   ! subroutine. The nature of the contouring algorithm, however, dictates
   ! that the transformation should maintain the rectangular topology of
   ! the grid, although grid-points may be allowed to coalesce.
   !
   ! As an example of a deformed rectangular grid, consider data given on
   ! the polar grid theta=0.1n(pi/2), for n=0,1,...,10, and r=0.25m,
   ! for m=0,1,..,4. This grid contains 55 points, of which 11 are
   ! coincident at the origin. The input array for PGCONX should be
   ! dimensioned (11,5), and data values should be provided for all 55
   ! elements.
   !
   ! Arguments:
   !  A      : data array.
   !  IDIM   : first dimension of A.
   !  JDIM   : second dimension of A.
   !  C      : array of NC contour levels; dimension at least NC.
   !  NC     : number of contour levels (less than or equal
   !           to dimension of C).
   !  ORDER  : 1 - straigth line segments are used
   !         : 2 - Quadratic Bézier segments are used.
   !
   !--
   ! 22-Dec-2021 - new routine from PGCONT_EC.
   !-----------------------------------------------------------------------

   integer :: i

   !------ end of declarations -- execution starts hereafter  ------

   if( nc == 0 ) return

   do i = 1, abs(nc) ! loop over the levels

      call pgcnscxy_ec( a, x, y, idim, jdim, c(i), order )

   end do

end subroutine
