! PGCONT_EC -- contour map of a 2D data array (rectangular) (modified EC)

subroutine PGCONT_EC( a, idim, jdim, c, nc, order )

   integer,          intent(in) :: idim, jdim, nc
   double precision, intent(in) :: a(idim,jdim), c(*)
   integer,          intent(in) :: order

   ! Compute a contour map of an array. Whereas PGCONT permits only a
   ! linear transformation between the (I,J) grid of the array and the
   ! world coordinate system (x,y), but PGCONX permits any transformation
   ! to be used, the transformation being defined by a user-supplied
   ! subroutine. The nature of the contouring algorithm, however, dictates
   ! that the transformation should maintain the rectangular topology of
   ! the grid, although grid-points may be allowed to coalesce.
   !
   ! Arguments:
   !  A      : data array.
   !  IDIM   : first dimension of A.
   !  JDIM   : second dimension of A.
   !  C      : array of NC contour levels; dimension at least NC.
   !  NC     : number of contour levels (less than or equal
   !           to dimension of C).
   !  ORDER  : 1 - straigth line segments are used
   !         : 2 - Quadratic Bézier segments are used.
   !
   !--
   ! 14-Nov-1985 - new routine [TJP].
   ! 12-Sep-1989 - correct documentation error [TJP].
   ! 22-Apr-1990 - corrected bug in panelling algorithm [TJP].
   ! 13-Dec-1990 - make errors non-fatal [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   !  7-Oct-2021 - Removed the 'plot' argument (routine), according the
   !               new redesign of the way of computing the contours from
   !               FGL (the Muesli Graphic Library).
   ! 13-Dec-2021 - Removed ranges for index I and J of A. Anyway, to contour
   !               a sub-array, the calling program may use slices indices.
   !-----------------------------------------------------------------------

   integer :: i

   !------ end of declarations -- execution starts hereafter  ------

   if( nc == 0 ) return

   do i = 1, abs(nc) ! loop over the levels

      call pgcnsc_ec( a, idim, jdim, c(i), order )

   end do

end subroutine
