! PGCN01XY_EC -- Auxiliary routine used by PGCNSCXY_EC (modified EC)

subroutine PGCN01XY_EC( z, x, y, mx, my, z0, flags, is, js, sdir, order )

use fml

   integer,          intent(in)     :: mx, my, is, js, sdir
   logical,          intent(in out) :: flags(mx,my,2)
   double precision, intent(in)     :: z(mx,*), x(mx,*), y(mx,*), z0
   integer,          intent(in)     :: order

   ! Support routine for PGCNSCXY_EC. This routine draws a continuous
   ! contour, starting at the specified point, until it either crosses
   ! the edge of the array or closes on itself.
   !
   ! This routine only process order=1, but it needs the knowledge of
   ! order, in order to store i_cell, j_cell and the side number for the
   ! Q point.

   !--
   ! 22-Dec-2021 - new routine from PGCN01_EC.
   !-----------------------------------------------------------------------

   integer, parameter :: up=1, down=2, left=3, right=4
   integer :: i, j, dir, i_cell_start, j_cell_start, i_cell, j_cell
   integer :: s, side_start
   double precision :: xx, yy, startx, starty
   double precision :: x_tmp, y_tmp, factor
   double precision :: x_up, y_up, d2_up, x_down, y_down, d2_down,      &
                       x_left, y_left, d2_left, x_right, y_right, d2_right

   !------ end of declarations -- execution starts hereafter  ------

   i = is
   j = js
   dir = sdir
   if( dir == up .or. dir == down ) then
      ! Crossing-point is between (i,j) and (i+1,j)
      call find_Q( x(i,j), x(i+1,j), y(i,j), y(i+1,j),                  &
                   z(i,j), z(i+1,j), z0, xx, yy )
   else ! left or right
      ! Crossing-point is between (i,j) and (i,j+1)
      call find_Q( x(i,j), x(i,j+1), y(i,j), y(i,j+1),                  &
                   z(i,j), z(i,j+1), z0, xx, yy )
   end if

   ! Start of the contour.
   i_cell = i
   j_cell = j
   if( dir == up .or. dir == down ) then
      if( dir == up ) then
         s = 1
      else ! down
         j_cell = j_cell - 1
         s = 3
      end if
   else ! left or right
      if( dir == left ) then
         i_cell = i_cell - 1
         s = 2
      else ! right
         s = 4
      end if
   end if
   call pg_store_contour( 0, i_cell, j_cell, xx, yy, z0, s=s )
   ! Save values: needed at end to close the contour if required.
   startx = xx
   starty = yy
   i_cell_start = i_cell
   j_cell_start = j_cell
   side_start = s

   ! We have reached grid-point (I,J) going in direction DIR (UP, DOWN, LEFT,
   ! or RIGHT). Look at the other three sides of the cell we are entering to
   ! decide where to go next. It is important to look to the two sides before
   ! looking straight ahead, in order to avoid self-intersecting contours. If
   ! all 3 sides have unused crossing-points, the cell is "degenerate" and we
   ! have to decide which of two possible pairs of contour segments to draw,
   ! by connecting the closest crossing-points.
   ! If we have reached the edge of the array, we have finished drawing an
   ! unclosed contour. If none of the other three sides of the cell have an
   ! unused crossing-point, we must have completed a closed contour, which
   ! requires a final segment back to the starting point.

10 continue
   goto (11, 12, 13, 14), dir

   !
   !          y(j+1) +----------+
   !                 |          |
   !                 |          |
   !                 |          |
   !                 |          |
   !                 |          |
   !            y(j) +----------+
   !               x(i)       x(i+1)

   ! dir = up
11 continue
   flags(i,j,1) = .false.
   if( j == my ) then
      return
   end if
   if( flags(i,j,2) ) then ! left
      if( flags(i+1,j,2) ) then ! right
         ! choix left ou right doit dépendre de la distance
         call find_Q( x(i,j), x(i,j+1), y(i,j), y(i,j+1),               &
                      z(i,j), z(i,j+1), z0, x_left, y_left )
         d2_left = (xx-x_left)**2 + (yy-y_left)**2
         i = i+1
         call find_Q( x(i,j), x(i,j+1), y(i,j), y(i,j+1),               &
                      z(i,j), z(i,j+1), z0, x_right, y_right )
         d2_right = (xx-x_right)**2 + (yy-y_right)**2
         if( d2_left < d2_right ) then
            i = i-1
            dir = left
         else
            dir = right
         end if
      else
         dir = left
      end if
      goto 20
   end if
   if( flags(i+1,j,2) ) then
      dir = right
      i = i+1
      goto 20
   end if
   if( flags(i,j+1,1) ) then
      j = j+1
      goto 25
   end if
   goto 30

   ! dir = down
12 continue
   flags(i,j,1) = .false.
   if( j == 1 ) then
      return
   end if
   if( flags(i+1,j-1,2) ) then ! right
      if( flags(i,j-1,2) ) then ! left
         i = i+1
         j = j-1
         call find_Q( x(i,j), x(i,j+1), y(i,j), y(i,j+1),               &
                      z(i,j), z(i,j+1), z0, x_right, y_right )
         i = i-1
         d2_right = (xx-x_right)**2 + (yy-y_right)**2
         call find_Q( x(i,j), x(i,j+1), y(i,j), y(i,j+1),               &
                      z(i,j), z(i,j+1), z0, x_left, y_left )
         d2_left = (xx-x_left)**2 + (yy-y_left)**2
         if( d2_right < d2_left ) then
            dir = right
            i = i+1
         else
            dir = left
         end if
      else
         dir = right
         i = i+1
         j = j-1
      end if
      goto 20
   end if
   if( flags(i,j-1,2) ) then
      dir = left
      j = j-1
      goto 20
   end if
   if( flags(i,j-1,1) ) then
      j = j-1
      goto 25
   end if
   goto 30

   ! dir = left
13 continue
   flags(i,j,2) = .false.
   if( i == 1 ) then
      return
   end if
   if( flags(i-1,j,1) ) then ! down
      if( flags(i-1,j+1,1) ) then ! up
         i = i-1
         call find_Q( x(i,j), x(i+1,j), y(i,j), y(i+1,j),               &
                      z(i,j), z(i+1,j), z0, x_down, y_down )
         d2_down = (xx-x_down)**2 + (yy-y_down)**2
         j = j+1
         call find_Q( x(i,j), x(i+1,j), y(i,j), y(i+1,j),               &
                      z(i,j), z(i+1,j), z0, x_up, y_up )
         d2_up = (xx-x_up)**2 + (yy-y_up)**2
         if( d2_down < d2_up ) then
            dir = down
            j = j-1
         else
            dir = up
         end if
      else
         dir = down
         i = i-1
      end if
      goto 25
   end if
   if( flags(i-1,j+1,1) ) then
      dir = up
      i = i-1
      j = j+1
      goto 25
   end if
   if( flags(i-1,j,2) ) then
      i = i-1
      goto 20
   end if
   goto 30

   ! dir = right
14 continue
   flags(i,j,2) = .false.
   if( i == mx ) then
      return
   end if
   if( flags(i,j+1,1) ) then ! up
      if( flags(i,j,1) ) then ! down
         j = j+1
         call find_Q( x(i,j), x(i+1,j), y(i,j), y(i+1,j),               &
                      z(i,j), z(i+1,j), z0, x_up, y_up )
         d2_up = (xx-x_up)**2 + (yy-y_up)**2
         j = j-1
         call find_Q( x(i,j), x(i+1,j), y(i,j), y(i+1,j),               &
                      z(i,j), z(i+1,j), z0, x_down, y_down )
         d2_down = (xx-x_down)**2 + (yy-y_down)**2
         if( d2_up < d2_down ) then
            dir = up
            j = j+1
         else
            dir = down
         end if
      else
         dir = up
         j = j+1
      end if
      goto 25
   end if
   if( flags(i,j,1) ) then
      dir = down
      goto 25
   end if
   if( flags(i+1,j,2) ) then
      i = i+1
      goto 20
   end if
   goto 30

   ! Add a point to the contour.
20 continue
   ! Crossing-point is between (i,j) and (i,j+1)
   call find_Q( x(i,j), x(i,j+1), y(i,j), y(i,j+1),                  &
                z(i,j), z(i,j+1), z0, xx, yy )
   i_cell = i
   j_cell = j
   if( dir == left .or. dir == right ) then
      if( dir == left ) then
         i_cell = i_cell - 1
         s = 2
      else ! right
         s = 4
      end if
   end if
   call pg_store_contour( 1, i_cell, j_cell, xx, yy, s=s )
   goto 10

25 continue
   ! Crossing-point is between (i,j) and (i+1,j)
   call find_Q( x(i,j), x(i+1,j), y(i,j), y(i+1,j),                  &
                z(i,j), z(i+1,j), z0, xx, yy )
   i_cell = i
   j_cell = j
   if( dir == up .or. dir == down ) then
      if( dir == up ) then
         s = 1
      else ! down
         j_cell = j_cell - 1
         s = 3
      end if
   end if
   call pg_store_contour( 1, i_cell, j_cell, xx, yy, s=s )
   goto 10

   ! If required, close the contour and go look for another one.
30 continue
   call pg_store_contour( 1, i_cell_start, j_cell_start,                &
                          startx, starty, s=side_start )

contains
!_______________________________________________________________________
!
   subroutine find_Q( xA, xB, yA, yB, a, b, z0, xQ, yQ )

      double precision, intent(in)  :: xA, yA, xB, yB, a, b, z0
      double precision, intent(out) :: xQ, yQ

      !
      !                      A +
      !                         \
      !                          \
      !                           +Q
      !                            \
      !                             \
      !                              + B
      !
      ! Knowing (a, b) the values of the z function at (A, B), we are
      ! looking for the location of the point Q such that:
      !                         z(Q) = z0

      double precision :: u

      u = (z0 - a)/(b - a)

      xQ = xA + u*(xB-xA)
      yQ = yA + u*(yB-yA)

   end subroutine find_Q
!_______________________________________________________________________
!
end subroutine
