! PGCN01_EC -- Auxiliary routine used by PGCNSC_EC (modified EC)

subroutine PGCN01_EC( z, mx, my, z0, flags, is, js, sdir, order )

   integer,          intent(in)     :: mx, my, is, js, sdir
   logical,          intent(in out) :: flags(mx,my,2)
   double precision, intent(in)     :: z(mx,*), z0
   integer,          intent(in)     :: order

   ! Support routine for PGCNSC. This routine draws a continuous contour,
   ! starting at the specified point, until it either crosses the edge of
   ! the array or closes on itself.
   !--
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   !  3-Oct-2021 - Fixed the arbitrary choice when a cell contains four
   !               crossing-points in itself. Same convention as Matlab
   !               and Octave.
   !  7-Oct-2021 - Removed the 'plot' argument (routine), according the
   !               new redesign of the way of computing the contours from
   !               FGL (The Muesli Graphic Library).
   !               Instead of plotting, the current routine stores the
   !               coordinates (x,y) of each point, and the reference
   !               indices (i,j) of the appropriate cell.
   ! 14-Dec-2021 - Order 2 implemented (Quadratic Bézier segments using 3
   !               points in each cell, instead of Straight line segments).
   !-----------------------------------------------------------------------

   integer, parameter :: up=1, down=2, left=3, right=4
   integer :: i, j, dir, i_cell_start, j_cell_start, i_cell, j_cell
   integer :: i_cell_last, j_cell_last
   double precision :: x, y, startx, starty, x_last, y_last, x_mid, y_mid
   double precision :: x_tmp, y_tmp
   double precision :: x_up, y_up, d2_up, x_down, y_down, d2_down,      &
                       x_left, y_left, d2_left, x_right, y_right, d2_right

   !------ end of declarations -- execution starts hereafter  ------

   i = is
   j = js
   dir = sdir
   if( dir == up .or. dir == down ) then
      x = dble(i) + (z0-z(i,j))/(z(i+1,j)-z(i,j))
      y = dble(j)
   else ! left or right
      x = dble(i)
      y = dble(j) + (z0-z(i,j))/(z(i,j+1)-z(i,j))
   end if

   ! Start of the contour.
   i_cell = i
   j_cell = j
   if( dir == down ) then
      j_cell = j_cell - 1
   else if( dir == left ) then
      i_cell = i_cell - 1
   end if
   call pg_store_contour( 0, i_cell, j_cell, x, y, z0 )
!!print "(2X,A,G0.4)", "PGCN01_EC: new contour. Value = ", z0
!!print "(6X,A,2(G0.5,2X),A,2(I0,2X))", " x, y = ", x, y,                 &
!!      " // i_cell, j_cell = ", i_cell, j_cell
   ! Save values: needed at end to close the contour if required.
   startx = x
   starty = y
   i_cell_start = i_cell
   j_cell_start = j_cell
   if( order == 2 ) then
      x_last = x
      y_last = y
      i_cell_last = i_cell
      j_cell_last = j_cell
   end if

   ! We have reached grid-point (I,J) going in direction DIR (UP, DOWN, LEFT,
   ! or RIGHT). Look at the other three sides of the cell we are entering to
   ! decide where to go next. It is important to look to the two sides before
   ! looking straight ahead, in order to avoid self-intersecting contours. If
   ! all 3 sides have unused crossing-points, the cell is "degenerate" and we
   ! have to decide which of two possible pairs of contour segments to draw,
   ! by connecting the closest crossing-points.
   ! If we have reached the edge of the array, we have finished drawing an
   ! unclosed contour. If none of the other three sides of the cell have an
   ! unused crossing-point, we must have completed a closed contour, which
   ! requires a final segment back to the starting point.

10 continue
   goto (11, 12, 13, 14), dir

   !
   !   j+1 +-------+
   !       |       |
   !       |       |
   !       |       |
   !    j  +-------+
   !       i      i+1

   ! dir = up
11 continue
   flags(i,j,1) = .false.
   if( j == my ) then
      return
   end if
   if( flags(i,j,2) ) then ! left
      if( flags(i+1,j,2) ) then ! right
         ! choix left ou right doit dépendre de la distance
         x_left = dble(i)
         y_left = dble(j) + (z0-z(i,j))/(z(i,j+1)-z(i,j))
         d2_left = (x-x_left)**2 + (y-y_left)**2
         i = i+1
         x_right = dble(i)
         y_right = dble(j) + (z0-z(i,j))/(z(i,j+1)-z(i,j))
         d2_right = (x-x_right)**2 + (y-y_right)**2
         if( d2_left < d2_right ) then
            i = i-1
            dir = left
         else
            dir = right
         end if
      else
         dir = left
      end if
      goto 20
   end if
   if( flags(i+1,j,2) ) then
      dir = right
      i = i+1
      goto 20
   end if
   if( flags(i,j+1,1) ) then
      j = j+1
      goto 25
   end if
   goto 30

   ! dir = down
12 continue
   flags(i,j,1) = .false.
   if( j == 1 ) then
      return
   end if
   if( flags(i+1,j-1,2) ) then ! right
      if( flags(i,j-1,2) ) then ! left
         i = i+1
         j = j-1
         x_right = dble(i)
         y_right = dble(j) + (z0-z(i,j))/(z(i,j+1)-z(i,j))
         i = i-1
         d2_right = (x-x_right)**2 + (y-y_right)**2
         x_left = dble(i)
         y_left = dble(j) + (z0-z(i,j))/(z(i,j+1)-z(i,j))
         d2_left = (x-x_left)**2 + (y-y_left)**2
         if( d2_right < d2_left ) then
            dir = right
            i = i+1
         else
            dir = left
         end if
      else
         dir = right
         i = i+1
         j = j-1
      end if
      goto 20
   end if
   if( flags(i,j-1,2) ) then
      dir = left
      j = j-1
      goto 20
   end if
   if( flags(i,j-1,1) ) then
      j = j-1
      goto 25
   end if
   goto 30

   ! dir = left
13 continue
   flags(i,j,2) = .false.
   if( i == 1 ) then
      return
   end if
   if( flags(i-1,j,1) ) then ! down
      if( flags(i-1,j+1,1) ) then ! up
         i = i-1
         x_down = dble(i) + (z0-z(i,j))/(z(i+1,j)-z(i,j))
         y_down = dble(j)
         d2_down = (x-x_down)**2 + (y-y_down)**2
         j = j+1
         x_up = dble(i) + (z0-z(i,j))/(z(i+1,j)-z(i,j))
         y_up = dble(j)
         d2_up = (x-x_up)**2 + (y-y_up)**2
         if( d2_down < d2_up ) then
            dir = down
            j = j-1
         else
            dir = up
         end if
      else
         dir = down
         i = i-1
      end if
      goto 25
   end if
   if( flags(i-1,j+1,1) ) then
      dir = up
      i = i-1
      j = j+1
      goto 25
   end if
   if( flags(i-1,j,2) ) then
      i = i-1
      goto 20
   end if
   goto 30

   ! dir = right
14 continue
   flags(i,j,2) = .false.
   if( i == mx ) then
      return
   end if
   if( flags(i,j+1,1) ) then ! up
      if( flags(i,j,1) ) then ! down
         j = j+1
         x_up = dble(i) + (z0-z(i,j))/(z(i+1,j)-z(i,j))
         y_up = dble(j)
         d2_up = (x-x_up)**2 + (y-y_up)**2
         j = j-1
         x_down = dble(i) + (z0-z(i,j))/(z(i+1,j)-z(i,j))
         y_down = dble(j)
         d2_down = (x-x_down)**2 + (y-y_down)**2
         if( d2_up < d2_down ) then
            dir = up
            j = j+1
         else
            dir = down
         end if
      else
         dir = up
         j = j+1
      end if
      goto 25
   end if
   if( flags(i,j,1) ) then
      dir = down
      goto 25
   end if
   if( flags(i+1,j,2) ) then
      i = i+1
      goto 20
   end if
   goto 30

   ! Add a point to the contour.
20 x = dble(i)
   y = dble(j) + (z0-z(i,j))/(z(i,j+1)-z(i,j))
   i_cell = i
   j_cell = j
   if( dir == left ) then
      i_cell = i_cell - 1
   end if
   if( order == 2 ) then
      ! must work in (i_cell_last, j_cell_last)...
      call pg_approx_hyperb_quadr_bezier( z(i_cell_last,j_cell_last),   &
                                          z(i_cell_last,j_cell_last+1), &
                                          z(i_cell_last+1,j_cell_last), &
                                          z(i_cell_last+1,j_cell_last+1), &
                                          y_last-j_cell_last, x_last-i_cell_last, &
                                          y-j_cell_last, x-i_cell_last, &
                                          x_tmp, y_tmp )
      x_mid = i_cell_last + y_tmp
      y_mid = j_cell_last + x_tmp
!!print "(3X,A,2(G0.5,2X),A,2(I0,2X))", "(+) x, y = ", x_mid, y_mid, &
!!      " // i_cell, j_cell = ", i_cell_last, j_cell_last
      call pg_store_contour( 1, i_cell_last, j_cell_last, x_mid, y_mid )
      x_last = x
      y_last = y
      i_cell_last = i_cell
      j_cell_last = j_cell
   end if
!!print *, "PGCN01_EC: store a point..."
!!print "(6X,A,2(G0.5,2X),A,2(I0,2X))", " x, y = ", x, y,                 &
!!      " // i_cell, j_cell = ", i_cell, j_cell
   call pg_store_contour( 1, i_cell, j_cell, x, y )
   goto 10

25 x = dble(i) + (z0-z(i,j))/(z(i+1,j)-z(i,j))
   y = dble(j)
   i_cell = i
   j_cell = j
   if( dir == down ) then
      j_cell = j_cell - 1
   end if
   if( order == 2 ) then
      ! must work in (i_cell_last, j_cell_last)...
      call pg_approx_hyperb_quadr_bezier( z(i_cell_last,j_cell_last),   &
                                          z(i_cell_last,j_cell_last+1), &
                                          z(i_cell_last+1,j_cell_last), &
                                          z(i_cell_last+1,j_cell_last+1), &
                                          y_last-j_cell_last, x_last-i_cell_last, &
                                          y-j_cell_last, x-i_cell_last, &
                                          x_tmp, y_tmp )
      x_mid = i_cell_last + y_tmp
      y_mid = j_cell_last + x_tmp
!!print "(3X,A,2(G0.5,2X),A,2(I0,2X))", "(+) x, y = ", x_mid, y_mid, &
!!      " // i_cell, j_cell = ", i_cell_last, j_cell_last
      call pg_store_contour( 1, i_cell_last, j_cell_last, x_mid, y_mid )
      x_last = x
      y_last = y
      i_cell_last = i_cell
      j_cell_last = j_cell
   end if
!!print *, "PGCN01_EC: store a point..."
!!print "(6X,A,2(G0.5,2X),A,2(I0,2X))", " x, y = ", x, y,                 &
!!      " // i_cell, j_cell = ", i_cell, j_cell
   call pg_store_contour( 1, i_cell, j_cell, x, y )
   goto 10

   ! If required, close the contour and go look for another one.
30 continue
   if( order == 2 ) then
      ! must work in (i_cell_last, j_cell_last)...
      call pg_approx_hyperb_quadr_bezier( z(i_cell_last,j_cell_last),      &
                                          z(i_cell_last,j_cell_last+1),    &
                                          z(i_cell_last+1,j_cell_last),    &
                                          z(i_cell_last+1,j_cell_last+1),  &
                                          y_last-j_cell_last, x_last-i_cell_last, &
                                          starty-j_cell_last, startx-i_cell_last, &
                                          x_tmp, y_tmp )
      x_mid = i_cell_last + y_tmp
      y_mid = j_cell_last + x_tmp
!!print "(3X,A,2(G0.5,2X),A,2(I0,2X))", "(+) x, y = ", x_mid, y_mid, &
!!      " // i_cell, j_cell = ", i_cell_last, j_cell_last
      call pg_store_contour( 1, i_cell_last, j_cell_last, x_mid, y_mid )
   end if
   call pg_store_contour( 1, i_cell_start, j_cell_start, startx, starty )

end subroutine
