subroutine pgbezier( ctrl )

   double precision, intent(in) :: ctrl(8)
   !------ API end ------

   ! arguments:
   !
   ! ctrl (real, input): world coordinates of the four
   !                                   control-points
   !--
   ! transforme en "device coordinates", puis écrit dans le fichier EPS ou PDF,
   ! sans subdivision des segments.
   ! 12-Sep-2001 - Creation [EC].
   ! 14-Mar-2005 - Ajout 'call grbpic' (nécessaire parfois)
   !               + update explicite de la BBOX [EC].
   ! 20-Mar-2005 - Correction des coords si leur valeur dépasse huge(1) [EC].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   ! 29-Mar-2021 - Remove update of the BBox in EPS and PDF drivers [EC].
   !--------------------------------------------------------------------

   double precision :: rbuf(4)
   integer :: ibuf(8)
   integer :: lchr
   character(len=1) :: chr
   character(len=6) :: TYPE
   integer :: length, i

!------ end of declarations -- execution starts hereafter  ------

   ! Begin picture if necessary.

   if( .not. grpltd(grcide) ) call grbpic

   if( grcide >= 1 ) then

      ibuf(1) = nint( ctrl(1) * grxscl(grcide) + grxorg(grcide) )
      ibuf(3) = nint( ctrl(3) * grxscl(grcide) + grxorg(grcide) )
      ibuf(5) = nint( ctrl(5) * grxscl(grcide) + grxorg(grcide) )
      ibuf(7) = nint( ctrl(7) * grxscl(grcide) + grxorg(grcide) )

      ibuf(2) = nint( ctrl(2) * gryscl(grcide) + gryorg(grcide) )
      ibuf(4) = nint( ctrl(4) * gryscl(grcide) + gryorg(grcide) )
      ibuf(6) = nint( ctrl(6) * gryscl(grcide) + gryorg(grcide) )
      ibuf(8) = nint( ctrl(8) * gryscl(grcide) + gryorg(grcide) )

      ! limite des coordonnées
      do i = 1, 8
         if( ibuf(i) > huge(1)/10. ) then
            write(0,*) "(MUESLI pgbezier:) ibuf(", i,                   &
                       ") limited to : ", huge(1)/10.
            ibuf(i) = huge(1)/10.
         end if
      end do

      call pgqinf( "TYPE", TYPE, length )
      if( TYPE == "EPS" ) then
         call eps_driver( DRAW_BEZIER_SEGM, rbuf, ibuf, chr, lchr )
      else if( TYPE == "PDF" ) then
         call pdf_driver( DRAW_BEZIER_SEGM, rbuf, ibuf, chr, lchr )
      end if

   end if

end subroutine pgbezier
!_______________________________________________________________________
!
subroutine pg_approx_hyperb_quadr_bezier( a, b, c, d, x1, y1, x2, y2,   &
                                          x_mid, y_mid )

   double precision, intent(in)  :: a, b, c, d, x1, y1, x2, y2
   double precision, intent(out) :: x_mid, y_mid

   ! Dans un carré unité [0,1]x[0,1], de valeur aux sommets a, b, c, d
   ! (aux points A, B, C, D ci-dessous)
   !
   !                            Q1
   !                     C  +---+-------+ D
   !                        |    .      |
   !                        |     .     |
   !                        |      .    |
   !                        |       .   |
   !                     A  +--------+--+ B
   !                                 Q2
   !
   ! on construit la surface z(x,y) bilinéaire suivante :
   ! calcul de alph, beta, gamm, delt, coeff de la fonction bilinéaire
   !        z(x,y) = alph x y + beta x + gamm y + delt
   ! Le contour de valeur z0 a donc pour équation implicite :
   !                      z(x,y) - z0 = 0
   ! (mais ici, on n'a pas besoin de z0 car la connaissance des points Q1
   !  et Q2 suffisent).

   double precision :: alph, beta, gamm, delt
   double precision :: t1_x, t1_y, t2_x, t2_y, det, mu

!------ end of declarations -- execution starts hereafter  ------

   ! determination of the four coefficient of the surface
   delt = a
   beta = b - a
   gamm = c - a
   alph = a - b - c + d

   if( abs(alph) < 1.0d-7 ) then
      x_mid = (x1 + x2)/2.0d0
      y_mid = (y1 + y2)/2.0d0
      return
   end if

   ! calcul du vecteur directeur des tangentes aux points du bord Q1 (x1,y1)
   ! et Q2 (x2,y2)
   t1_x = -(alph*x1+gamm)
   t1_y =   alph*y1+beta
   t2_x = -(alph*x2+gamm)
   t2_y =   alph*y2+beta

   ! calcul de l'intersection C des tangentes en Q1 et Q2
   !     x - x1 = mu*t1_x
   !     y - y1 = mu*t1_y     =>    mu*t1_x - nu*t2_x = x2 - x1
   !     x - x2 = nu*t2_x           mu*t1_y - nu*t2_y = y2 - y1
   !     y - y2 = nu*t2_y
   !
   det = -t1_x*t2_y + t1_y*t2_x
   if( abs(det) < 1.0d-7 ) then
      x_mid = (x1 + x2)/2.0d0
      y_mid = (y1 + y2)/2.0d0
      return
   end if

   mu = ( (y2-y1)*t2_x - (x2-x1)*t2_y )/det

   x_mid = x1 + mu*t1_x
   y_mid = y1 + mu*t1_y

end subroutine pg_approx_hyperb_quadr_bezier
