subroutine pgbar_stacks_ec( n, n_groups, x, ldy, y,                     &
                            width, baseline, colorindex )

   integer :: n, n_groups, ldy
   double precision :: x(*), y(ldy,*), width, baseline
   integer, optional :: colorindex(*)
   !------ API end ------

   ! Draw a bar plot (stacked bars).
   ! Y-axis must be linear
   !
   !--
   !  2-Sep-17: Created from pgbar_ec [EC].
   !--------------------------------------------------------------------
   integer :: i, j, icol
   double precision :: x_w, barwidth
   double precision :: x_min, x_max, y_min, y_max
   !------ end of declarations -- execution starts hereafter  ------

   call pgbbuf()

   x_w = (maxval(x(1:n))-minval(x(1:n)))/(n-1)
   barwidth = x_w*width

   do i = 1, n
      icol = 22
      y_min = baseline
      do j = 1, n_groups
         if( present(colorindex) ) then
            call grsci(colorindex(j))
         else
            ! cycling colors in the new Matlab colortable (between 23 and 29)
            icol = icol + 1
            if( icol > 29 ) icol = 23
            call grsci(icol)
         end if
         x_min = x(i) - barwidth/2.
         x_max = x(i) + barwidth/2.
         y_max = y_min + y(i,j)
         if( y_max == baseline ) then
            continue
         else
            call grrect( x_min, y_min, x_max, y_max, filled=.true. )
         end if
         y_min = y_max
      enddo
   enddo

   call pgebuf()

end subroutine pgbar_stacks_ec
!_______________________________________________________________________
!
subroutine pgbar_stacks_log_ec( n, n_groups, x, ldy, y,                 &
                                width, baseline, colorindex )

   integer :: n, n_groups, ldy
   double precision :: x(*), y(ldy,*), width, baseline
   integer, optional :: colorindex(*)
   !------ API end ------

   ! Draw a bar plot (stacked bars)
   ! Y-axis must be logarithmic (therefore, log function must be
   ! applied just before drawing)
   !
   !--
   ! 10-Mar-25: Adapted from pgbar_stacks_ec [EC].
   !--------------------------------------------------------------------
   integer :: i, j, icol
   double precision :: x_w, barwidth
   double precision :: x_min, x_max, y_min, y_max
   !------ end of declarations -- execution starts hereafter  ------

   call pgbbuf()

   x_w = (maxval(x(1:n))-minval(x(1:n)))/(n-1)
   barwidth = x_w*width

   do i = 1, n
      icol = 22
      y_min = baseline
      do j = 1, n_groups
         if( present(colorindex) ) then
            call grsci(colorindex(j))
         else
            ! cycling colors in the new Matlab colortable (between 23 and 29)
            icol = icol + 1
            if( icol > 29 ) icol = 23
            call grsci(icol)
         end if
         x_min = x(i) - barwidth/2.
         x_max = x(i) + barwidth/2.
         y_max = y_min + y(i,j)
         if( y_max == baseline ) then
            continue
         else
            call grrect( x_min, log10(y_min), x_max, log10(y_max),      &
                         filled=.true. )
         end if
         y_min = y_max
      enddo
   enddo

   call pgebuf()

end subroutine pgbar_stacks_log_ec
