subroutine pgbar_groups_ec( n, n_groups, x, ldy, y, width, baseline, colorindex )

   integer :: n, n_groups, ldy
   double precision :: x(*), y(ldy,*), width, baseline
   integer, optional :: colorindex(*)
   !------ API end ------

   ! Draw a bar plot (groups of bars)
   !
   !--
   !  1-Sep-17: created from pgbar_ec
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !--------------------------------------------------------------------

   integer :: i, j, icol
   double precision :: x_w, x_sub_w, ssw, xcenter, barwidth
   double precision :: x_min, x_max, y_min, y_max
   !------ end of declarations -- execution starts hereafter  ------

   call pgbbuf()

   x_w = (maxval(x(1:n))-minval(x(1:n)))/(n-1)
   x_sub_w = 0.8d0*x_w
   ssw = x_sub_w/n_groups
   barwidth = ssw*width

   y_min = baseline
   do i = 1, n
      icol = 22
      do j = 1, n_groups
         if( present(colorindex) ) then
            call grsci(colorindex(j))
         else
            ! cycling colors in the new Matlab colortable (between 23 and 29)
            icol = icol + 1
            if( icol > 29 ) icol = 23
            call grsci(icol)
         end if
         xcenter = x(i) + (j-n_groups/2.)*ssw - ssw/2.
         x_min = xcenter - barwidth/2.
         x_max = xcenter + barwidth/2.
         y_max = y(i,j)
         if( y_max == baseline ) then
            continue
         else
            call grrect( x_min, y_min, x_max, y_max, filled=.true. )
         end if
      enddo
   enddo

   call pgebuf()

end subroutine
