subroutine PGARRO_HEAD_ONLY( x2, y2, angle )

   double precision :: x2, y2, angle

   ! Draw only an arrow head at (X2,Y2) (world-coordinates), in the direction
   ! given by angle. The size of the arrowhead is determined by the current
   ! character size set by routine PGSCH. The default size is 1/40th of the
   ! smaller of the width or height of the view surface.
   ! The appearance of the arrowhead (shape and solid or open) is
   ! controlled by routine PGSAH.
   !
   ! Arguments:
   !  X2, Y2 (input) : world coordinates of the head of the arrow.
   !  ANGLE  (input) : direction of the arrow head, in radians
   !--
   ! 10-Jan-2020 - Creation from PGARRO (EC).
   !-----------------------------------------------------------------------

   integer :: ahfs, fs
   double precision :: xv1, xv2, yv1, yv2, xl, xr, yb, yt, dindx, dindy
   double precision :: ca, sa, so, co, yp, xp, ym, xm, dhx, dhy
   double precision :: px(4), py(4)
   double precision :: ahangl, ahvent, semang, ch, dh, xs1, xs2, ys1, ys2

   call pgbbuf()
   call pgqah(ahfs, ahangl, ahvent)
   call pgqfs(fs)
   call pgsfs(ahfs)
   call pgqch(ch)
   call pgqvsz(1, xs1, xs2, ys1, ys2)
   ! length of arrowhead: 1/40th of the smaller of the height or
   ! width of the view surface, scaled by character height.
   dh = ch*min(abs(xs2-xs1),abs(ys2-ys1))/40.0d0
   call grmova(x2, y2)
   ! Is there to be an arrowhead ?
   if( dh > 0.0d0 ) then
      ! Get x and y scales
      call pgqvp(1, xv1, xv2, yv1, yv2)
      call pgqwin(xl, xr, yb, yt)
      if( xr /= xl .and. yt /= yb) then
         dindx = (xv2 - xv1) / (xr - xl)
         dindy = (yv2 - yv1) / (yt - yb)
         dhx = dh / dindx
         dhy = dh / dindy
         ca = cos(angle)
         sa = sin(angle)
         ! Semiangle in radians
         semang = ahangl/2.00d0*deg_to_rad
         so = sin(semang)
         co = -cos(semang)
         ! Vector back along one edge of the arrow
         xp = dhx * (ca*co - sa*so)
         yp = dhy * (sa*co + ca*so)
         ! Vector back along other edge of the arrow
         xm = dhx * (ca*co + sa*so)
         ym = dhy * (sa*co - ca*so)
         ! Draw the arrowhead
         px(1) = x2
         py(1) = y2
         px(2) = x2 + xp
         py(2) = y2 + yp
         px(3) = x2 + 0.50d0*(xp+xm)*(1.00d0-ahvent)
         py(3) = y2 + 0.50d0*(yp+ym)*(1.00d0-ahvent)
         px(4) = x2 + xm
         py(4) = y2 + ym
         call pgpoly(4, px, py)
      end if
   end if
   call grmova(x2,y2)
   call pgsfs(fs)
   call pgebuf()

end subroutine
