subroutine pg_spline_to_bezier( n, absc_curv, xpts, ypts, wxpts, wypts, &
                                nctrl, xctrl, yctrl )

   integer,          intent(in) :: n
   double precision, intent(in) :: absc_curv(n), xpts(n), ypts(n),      &
                                   wxpts(n), wypts(n)
   integer,          intent(out) :: nctrl
   double precision, intent(out) :: xctrl(3*(n-1)+1), yctrl(3*(n-1)+1)
   !------ API end ------

   !-- only compute the Bézier control points for a given cubic spline

   double precision :: hi
   integer :: i, offset
   !------ end of declarations -- execution starts hereafter  ------

   nctrl = 3*(n-1) + 1

   do i = 2, n

      hi = absc_curv(i) - absc_curv(i-1)

      offset = 3*(i-2)

      xctrl(offset+1) = xpts(i-1)
      yctrl(offset+1) = ypts(i-1)

      xctrl(offset+2) = 2.0d0/3.0d0*xpts(i-1) - 1.0d0/9.0d0 *wxpts(i-1)*hi**2 + &
                        1.0d0/3.0d0*xpts(i)   - 1.0d0/18.0d0*wxpts(i)*hi**2
      yctrl(offset+2) = 2.0d0/3.0d0*ypts(i-1) - 1.0d0/9.0d0 *wypts(i-1)*hi**2 + &
                        1.0d0/3.0d0*ypts(i)   - 1.0d0/18.0d0 *wypts(i)*hi**2

      xctrl(offset+3) = 1.0d0/3.0d0*xpts(i-1) - 1.0d0/18.0d0*wxpts(i-1)*hi**2 + &
                        2.0d0/3.0d0*xpts(i)   - 1.0d0/9.0d0 *wxpts(i)*hi**2
      yctrl(offset+3) = 1.0d0/3.0d0*ypts(i-1) - 1.0d0/18.0d0*wypts(i-1)*hi**2 + &
                        2.0d0/3.0d0*ypts(i)   - 1.0d0/9.0d0 *wypts(i)*hi**2

   end do

   xctrl(nctrl) = xpts(n)
   yctrl(nctrl) = ypts(n)

end subroutine
