subroutine GRPOCL_EC( n, px, py, pc, edge, val, maxout,                 &
                      nout, qx, qy, qc )

   integer :: n, nout, edge, maxout
   double precision :: px(*), py(*), qx(*), qy(*)
   integer :: pc(*), qc(*)
   double precision :: val
   !------ API end ------

   ! Clip a polygon against a rectangle: Sutherland-Hodgman algorithm.
   ! this routine must be called four times to clip against each of the
   ! edges of the rectangle in turn.
   !
   ! Arguments:
   !
   ! N (input, integer): the number of vertices of the polygon (at least
   !       3).
   ! PX, PY (input, real arrays, dimension at least N): world coordinates
   !       of the N vertices of the input polygon.
   ! PC (input, real arrays, dimension at least N): colors attached to
   !       each input vertex.
   ! EDGE (input, integer):
   !     1: clip against left edge,   X > XMIN=VAL
   !     2: clip against right edge,  X < XMAX=VAL
   !     3: clip against bottom edge, Y > YMIN=VAL
   !     4: clip against top edge,    Y < YMIN=VAL
   ! VAL  (input, real): coordinate value of current edge.
   ! MAXOUT (input, integer): maximum number of vertices allowed in
   !     output polygon (dimension of QX, QY).
   ! NOUT (output, integer): the number of vertices in the clipped polygon.
   ! QX, QY (output, real arrays, dimension at least MAXOUT): world
   !       coordinates of the NOUT vertices of the output polygon.
   ! QC (output, real arrays, dimension at least MAXOUT): colors attached
   !       to each output vertex
   !--
   ! 31-Aug-2004 - Created from GRPOCL: add color array attached to
   !               vertices [EC].
   ! 13-Sep-2004 - Fix test detecting clipping [EC].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !--------------------------------------------------------------------
   INTEGER :: I
   double precision :: FX, FY, FC, SX, SY, SC
   !------ end of declarations -- execution starts hereafter  ------

   nout = 0
   do i = 1, n
      if( i == 1 ) then
         ! Save first point
         fx = px(i)
         fy = py(i)
         fc = pc(i)
      else if( (edge == 1 .or. edge == 2) .and.                         &
               (px(i)/=val .and. sx/=val)       ) then
         if( sign(1.0d0,px(i)-val) /= sign(1.0d0,sx-val) ) then
            ! SP intersects this edge: output vertex at intersection
            nout = nout + 1
            if( nout <= maxout ) then
               qx(nout) = val
               qy(nout) = sy + (py(i)-sy)*((val-sx)/(px(i)-sx))
               qc(nout) = sc + (pc(i)-sc)*((val-sx)/(px(i)-sx))
            end if
         end if
      else if( (edge == 3 .or. edge == 4) .and.                         &
               (py(i)/=val .and. sy/=val)       ) then
         if( sign(1.0d0,py(i)-val) /= sign(1.0d0,sy-val) ) then
            ! SP intersects this edge: output vertex at intersection
            nout = nout + 1
            if( nout <= maxout ) then
               qx(nout) = sx + (px(i)-sx)*((val-sy)/(py(i)-sy))
               qy(nout) = val
               qc(nout) = sc + (pc(i)-sc)*((val-sy)/(py(i)-sy))
            end if
         end if
      end if
      sx = px(i)
      sy = py(i)
      sc = pc(i)
      if( (edge == 1.and.sx >= val) .or.                                &
          (edge == 2.and.sx <= val) .or.                                &
          (edge == 3.and.sy >= val) .or.                                &
          (edge == 4.and.sy <= val)      ) then
         ! output visible vertex S
         nout = nout + 1
         if( nout <= maxout ) then
             qx(nout) = sx
             qy(nout) = sy
             qc(nout) = sc
         end if
      end if
   end do
   ! Does SF intersect edge?
   if( (edge == 1 .or. edge == 2) .and.                                 &
       (sx/=val .and. fx/=val)          ) then
      if( sign(1.0d0,sx-val) /= sign(1.0d0,fx-val) ) then
         nout = nout + 1
         if( nout <= maxout ) then
            qx(nout) = val
            qy(nout) = sy + (fy-sy)*((val-sx)/(fx-sx))
            qc(nout) = sc + (fc-sc)*((val-sx)/(fx-sx))
         end if
      end if
   else if( (edge == 3 .or. edge == 4) .and.                            &
            (sy/=val .and. fy/=val)          ) then
      if( sign(1.0d0,sy-val) /= sign(1.0d0,fy-val) ) then
         nout = nout + 1
         if( nout <= maxout ) then
            qy(nout) = val
            qx(nout) = sx + (fx-sx)*((val-sy)/(fy-sy))
            qc(nout) = sc + (fc-sc)*((val-sy)/(fy-sy))
         end if
      end if
   end if

end subroutine
