! GROPEN_EC -- open device for graphics (only for X11)

integer function GROPEN_EC( type, file, ident,                          &
                            geom, exe_name, win_id, title )

   integer,          intent(in)  :: type
   character(len=*), intent(in)  :: file

   integer,          intent(in)  :: geom(4)
   character(len=*), intent(in)  :: exe_name
   integer,          intent(in)  :: win_id
   character(len=*), intent(in)  :: title
   integer,          intent(out) :: ident
   !------ API end ------

   ! GRPCKG: assign a device and prepare for plotting.  GROPEN must be
   ! called before all other calls to GRPCKG routines.
   !
   ! Returns:
   !
   ! GROPEN (output, integer): 1 -> success, any other value indicates a
   !       failure. In the event of an error, a message will be sent to
   !       the standard error unit.
   !
   ! Arguments:
   !
   ! TYPE (input, integer): default device type (integer code).
   ! DUMMY (input, integer): not used at present.
   ! FILE (input, character): plot specifier, of form 'device/type'.
   ! IDENT (output, integer): plot identifier to be used in later
   !       calls to GRPCKG.
   !
   !       -2004 - Créé à partir de GROPEN : rajout de plusieurs arguments
   !               pour communiquer avec les drivers [EC].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   ! 26-Mar-2020 - Removed rbuf(5) when calling grexec with IFUNC=9; it
   !               has been added just to check that the call comes from
   !               the Muesli library and not from the user. But now the
   !               symbol 'grexec' is made private in the FGL module [EC].
   !  4-Apr-2020 - initialize marker size (grmsiz) to its default value [EC].
   !--------------------------------------------------------------------

   integer :: ier, ftype, ibuf(5), lchr
   double precision :: rbuf(1)
   logical :: append
   character(len=512) :: ffile, chr

   logical, save :: MFPLOT_DIR_SENT = .false.

   !------ end of declarations -- execution starts hereafter  ------

   ! GRINIT call has been removed, as this routine is always called by
   ! PGOPEN_EC which call itself GRINIT (via PGINIT).

   ! Allocate an identifier.
   ident = 1
   do while( grstat(ident) /= 0 )
      ident = ident + 1
      if( ident > grimax ) then
         call grwarn("Too many active plots.")
         gropen_ec = -1
         ident = 0
         return
      end if
   end do

   ! Validate the device specification.
   ! (GRPARS set GRGTYP to the right value, via GRDTYP)
   ier = grpars( file, ffile, ftype, append )
   if( ier /= 1 ) then
      chr = "Invalid device specification: "
      chr(31:) = file
      call grwarn(chr)
      gropen_ec = -1
      return
   end if
   if( ftype == 0 ) ftype = type
   if( 1 <= ftype ) then
      grtype(ident) = ftype
   else
      chr = "Device type omitted or invalid: "
      chr(33:) = file
      call grwarn(chr)
      gropen_ec = -1
      return
   end if

   ! Send the X11 window ID of the terminal
   ibuf(1) = MF_TERMINAL_X11_ID
   call grexec( grgtyp, SET_X11_WIN_ID, rbuf, ibuf, chr, lchr )

   ! Send the Muesli installation directory to xwdriv (only one time)
   if( .not. MFPLOT_DIR_SENT ) then
      if( MFPLOT_DIR == "" ) then
         ! get the installation directory
         call set_muesli_install_dir_fgl()
      end if
      chr = trim(MFPLOT_DIR) // char(0)
      call grexec( grgtyp, SET_MUESLI_PATH, rbuf, ibuf, chr, lchr )
      MFPLOT_DIR_SENT = .true.
   end if

   ! Install the file name, or assign default.
   if( ffile == " " ) then
       call grexec( grgtyp, GET_DEF_FILENAME, rbuf, ibuf, ffile, lchr )
   end if
   grfile(ident) = ffile
   grfnln(ident) = max(1,len_trim(grfile(ident)))

   ! Warning, cannot yet use 'PGQINF' because PGDEVS(PGID) == 0
   ! PGDEVS will be assigned in pgopen_ec, few lines after the call
   ! of gropen_ec!
   if( file == "/XWIN" ) then
      ! Sending executable name, window id, title (only for X11 driver)
      ibuf(1) = win_id
      ibuf(2) = len_trim(title)
      ! as we want to pass two different character strings (exe_name and title),
      ! we choose to concatenate them...
      chr = trim(exe_name) // trim(title) // char(0)
      lchr = len_trim(exe_name) ! length of first part only
      call grexec( grgtyp, SET_EXE_NAME, rbuf, ibuf, chr, lchr )
   else if( file /= "/NULL" ) then
      STOP "Internal error: gropen_ec must be used only with /XWIN or /NULL!"
   end if

   ! Opening device with required geometry in pixels
   ibuf(1) = geom(1)
   ibuf(2) = geom(2)
   ibuf(3) = geom(3)
   ibuf(4) = geom(4)
   ibuf(5) = ident
   call grexec( grgtyp, OPEN_DEV, rbuf, ibuf, grfile(ident), grfnln(ident) )
   gropen_ec = ibuf(2)
   if( gropen_ec /= 1 ) then
      ident = 0
      return
   end if
   grunit(ident) = ibuf(1)
   grpltd(ident) = .false.
   grstat(ident) = 1
   call grslct(ident)

   ! Install the default plot parameters

   ! Inquire color-index range.
   call grexec( grgtyp, GET_COL_IND_RANGE, rbuf, ibuf, chr, lchr )
   grmnci(ident) = ibuf(1)
   grmxci(ident) = ibuf(2)
   ! Inquire resolution.
   call grexec( grgtyp, GET_DEV_RESOL, rbuf, ibuf, chr, lchr )
   grpxpi(ident) = ibuf(1)
   grpypi(ident) = ibuf(2)
   ! Set default character size: the X11 driver is designed to use 1.0
   grcfac(ident) = 1.0d0

   ! Inquire plot size. Note that margins have been added, see xwdriv.c
   ! at the end of function 'xw_new_geom': 'Add 1/4" margins' (~ 6.3 mm)
   ! For X11, the plot size cannot be determined in advance, since all
   ! geometry requests cannot always be honored (think about a too large
   ! window for the screen), therefore such a request to the X11 driver
   ! is unavoidable.
   ibuf(1) = 1 ! need to wait a few tens of milliseconds
   rbuf(1) = 1. ! request of the full drawing area
   call grexec( grgtyp, GET_DEF_SIZE, rbuf, ibuf, chr, lchr )
   grxmxa(ident) = ibuf(2)
   grymxa(ident) = ibuf(4)
   ! Inquire device capabilities.
   grgcap(ident) = "NNNNNNNNNN"
   call grexec( grgtyp, GET_MISC_INFO, rbuf, ibuf, chr, lchr )
   grgcap(ident) = chr(1:lchr)
   ! Current pen position.
   grxpre(ident) = 0.0d0
   grypre(ident) = 0.0d0

   ! Default attributes.
   grccol(ident) = -1    ! color not yet defined
   grstyl(ident) = 1     ! line-style (continuous)
   grwidt(ident) = 1.0d0 ! line-width (standard)
   grcmrk(ident) = 1     ! marker number (dot)
   grmsiz(ident) = 1.0d0 ! marker size

   ! set color index
   ! (before beginning the drawing, the X11 driver needs to have
   !  last_color_index initialized)
   ibuf(1) = 1
   call grexec( grgtyp, SELECT_COL_IND, rbuf, ibuf, chr, lchr )

   gropen_ec = 1

end function
