! Keep this file encoded in ISO-8859-15 (Latin-1). We have to send special
! UTF-8 chars using two chars (e.g. \oe, \OE, ...)

subroutine grlen_xft( string, s_width, s_h_min, s_h_max )

   character(len=*), intent(in) :: string
   double precision :: s_width, s_h_min, s_h_max
   !------ API end ------

   ! GRPCKG: Find the bounding box of the string, using Xft.
   !         => computes the width and heights of the total string,
   !            by simulating the drawing of the string using the
   !            X11 driver.
   !
   ! Arguments:
   !
   !     STRING (in) : the character string to be plotted. This may
   !                   include standard escape-sequences to represent
   !                   non-ASCII characters and special commands. The
   !                   number of characters in STRING (i.e., LEN(STRING))
   !                   should not exceed 256.
   !
   !--
   ! 19-Feb-2021 - Creation from grlen_xft [EC].
   !-----------------------------------------------------------------------

   character(len=48), parameter :: greek = "ABGDEZHQIKLMNXOPRSTUFCYW"   &
                                        // "abgdezhqiklmnxoprstufcyw"

   character(len=8), parameter :: greek_names(52) =                     &
                [ "Alpha   ", "Beta    ", "Gamma   ", "Delta   ",       &
                  "Epsilon ", "Zeta    ", "Eta     ", "Theta   ",       &
                  "Iota    ", "Kappa   ", "Lambda  ", "Mu      ",       &
                  "Nu      ", "Xi      ", "Omicron ", "Pi      ",       &
                  "Rho     ", "Sigma   ", "Tau     ", "Upsilon ",       &
                  "Phi     ", "Chi     ", "Psi     ", "Omega   ",       &
                  "alpha   ", "beta    ", "gamma   ", "delta   ",       &
                  "epsilon ", "zeta    ", "eta     ", "theta   ",       &
                  "iota    ", "kappa   ", "lambda  ", "mu      ",       &
                  "nu      ", "xi      ", "omicron ", "pi      ",       &
                  "rho     ", "sigma   ", "tau     ", "upsilon ",       &
                  "varphi  ", "chi     ", "psi     ", "omega   ",       &
                  "vartheta", "varpi   ", "varsigma", "phi     " ]

   integer, parameter :: greek_ind(24) =                                &
                [ 65, 66, 71, 68, 69, 90, 72, 81, 73, 75, 76, 77,       &
                  78, 88, 79, 80, 82, 83, 84, 85, 70, 67, 89, 87 ]

   ! current position for writing a subpart of the string
   double precision :: x, y, dx, dy, width
   double precision :: FNTFAC, RFNTBAS
   double precision :: factor, font_size
   logical :: found
   integer :: dash_length

   character :: c
   integer :: IFNTLV, i, j, k, n, buf_start, buf_len
   character :: fontcode, old_fontcode

!### TODO:
! attention, dsormais on travaille par substring (autant d'appel  Xft)
! et non plus par glyph ! La manire de traiter va tre compltment
! diffrente...
   ! memory of char widths (for cumulative backspace)
   ! width_mem:  successive widths for each substring drawn
   double precision :: width_mem(256)
   integer :: i_mem, i_back

   character(len=11) :: guess

   double precision :: rbuf(4)
   integer :: ibuf(2), lchr
   character(len=256) :: chr

   !------ end of declarations -- execution starts hereafter  ------
stop 'grlen_xft: ready or not?' ! not called in FGL actually...

   s_width = 0.0d0
   s_h_min = 0.0d0
   s_h_max = 0.0d0

   ! Check that there is something to be plotted.
   if( len(string) == 0 ) return

   ! Check that a device is selected.
   if( grcide < 1 ) then
      call grwarn('GRLEN_XFT - no graphics device is active.')
      return
   end if

   ! Compute base scaling and orientation.
   ! (assuming ratio=1, i.e. the X11 device has the same resolution
   ! in both direction -- pixels are squared)
   factor = grcfac(grcide)/2.5d0 ! old value of GRTEXT for Hershey font
   ! the multiplicative coefficient below has been determined to obtain
   ! the same character dimension (width and height) as in EPS and PDF.
   font_size = factor * 22.9d0

   !###############################################################
   ! parse and simulate the drawing of the string
   !###############################################################

   ! trailing blanks are allowed, therefore don't use len_trim()
   n = len(string)
   buf_len = 0

   ! current position
   x = 55.20d0
   y = 276.0d0

   ! misc. initialization
   IFNTLV = 0
   FNTFAC = 1.0d0
   i_mem = 0
   i_back = 0

   ! default font
   fontcode = "n"

   i = 1
   do

      if( i >= n+1 ) then
         call flush_buffer()
         exit
      end if

      if( string(i:i) == "-" ) then
         ! hyphen
         dash_length = 1
         i = i + 1
         if( gr_minus_sign_math_mode ) then
            ! for writing numerical labels of axes, a minus in math mode
            ! is systematically used...
            dash_length = 2
         end if
         call flush_buffer()
         if( dash_length == 1 ) then
            ! Le tiret "hyphen" doit tre crit en StandardEncoding, sinon
            ! il est trs long (comme "minus" en mode math). Pour avoir un
            ! "minus" en mode math, utiliser "\-".
            call ps_font_char_width( 45, fontcode, width )
            width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
            i_mem = i_mem + 1
            width_mem(i_mem) = width
            i_back = i_mem
            call send_few_chars( "-", 1, UTF8=.false. ) ! ( (C 45)
         else ! dash_length == 2
            ! "minus" en mode math, ou "endash"
            call ps_font_char_width( 29, fontcode, width )
            width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
            i_mem = i_mem + 1
            width_mem(i_mem) = width
            i_back = i_mem
            call send_few_chars( "–", 3, UTF8=.true. ) ! endash (C 29)
         end if
         cycle
      else if( string(i:i) == "\" ) then
         call flush_buffer()
         if( i+2 <= n ) then
            select case( string(i+1:i+2) )
               case( "fn" )
                  fontcode = string(i+2:i+2)
                  i = i + 3
                  cycle
               case( "fN" )
                  fontcode = string(i+2:i+2)
                  i = i + 3
                  cycle
               case( "fi" )
                  fontcode = string(i+2:i+2)
                  i = i + 3
                  cycle
               case( "fI" )
                  fontcode = string(i+2:i+2)
                  i = i + 3
                  cycle
               case( "fr" )
                  fontcode = string(i+2:i+2)
                  i = i + 3
                  cycle
               case( "fR" )
                  fontcode = string(i+2:i+2)
                  i = i + 3
                  cycle
               case( "fs" )
                  fontcode = string(i+2:i+2)
                  i = i + 3
                  cycle
               case( "OE" )
                  call ps_font_char_width( 128, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  i_mem = i_mem + 1
                  width_mem(i_mem) = width
                  i_back = i_mem
                  call send_few_chars( "Œ", 2, UTF8=.true. )
                  i = i + 3
                  cycle
               case( "oe" )
                  call ps_font_char_width( 136, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  i_mem = i_mem + 1
                  width_mem(i_mem) = width
                  i_back = i_mem
                  call send_few_chars( "œ", 2, UTF8=.true. )
                  i = i + 3
                  cycle
               case( "s1" )
                  ! standard space
                  ! get width of standard space
                  call ps_font_char_width( 32, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  dx = width
                  call rmoveto( dx, 0.0d0 )
                  i_mem = i_mem + 1
                  width_mem(i_mem) = dx
                  i_back = i_mem
                  i = i + 3
                  cycle
               case( "s2" )
                  ! thin space (half of standard one)
                  ! get width of standard space
                  call ps_font_char_width( 32, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  dx = width/2.0d0
                  call rmoveto( dx, 0.0d0 )
                  i_mem = i_mem + 1
                  width_mem(i_mem) = dx
                  i_back = i_mem
                  i = i + 3
                  cycle
               case( "s3" )
                  ! very thin space (one fourth of standard one)
                  ! get width of standard space
                  call ps_font_char_width( 32, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  dx = width/4.0d0
                  call rmoveto( dx, 0.0d0 )
                  i_mem = i_mem + 1
                  width_mem(i_mem) = dx
                  i_back = i_mem
                  i = i + 3
                  cycle
               case default
                  ! do nothing
            end select
         end if
         if( i+1 <= n ) then
            select case( string(i+1:i+1) )
               case( "u" )
                  IFNTLV = IFNTLV + 1
                  RFNTBAS = + 0.65d0*FNTFAC
                  dy = RFNTBAS*ps_char_height
                  call rmoveto( 0.0d0, dy )
                  FNTFAC = GR_SUBSCRIPT_SCALING**ABS(IFNTLV)
                  i = i + 2
                  cycle
               case( "d" )
                  IFNTLV = IFNTLV - 1
                  FNTFAC = GR_SUBSCRIPT_SCALING**ABS(IFNTLV)
                  RFNTBAS = - 0.65d0*FNTFAC
                  dy = RFNTBAS*ps_char_height
                  call rmoveto( 0.0d0, dy )
                  i = i + 2
                  cycle
               case( "b" )
                  ! go backspace -- width of the previous character(s)
                  dx = width_mem(i_back)
                  call rmoveto( -dx, 0.0d0 )
                  i_back = i_back - 1
                  i = i + 2
                  cycle
               case( "(" )
                  !  explicit name for a greek letter
                  found = .false.
                  ! searching end of letter
                  do k = i+2, n
                     if( string(k:k) == ")" ) then
                        found = .true.
                        exit
                     end if
                  end do
                  if( .not. found ) then
                     print *, 'error: ")" not found in: "', string(i+2:n), '"'
                     return
                  end if
                  ! decode greek letter from string(i+2:k-1)
                  found = .false.
                  do j = 1, size(greek_names)
                     if( string(i+2:k-1) == greek_names(j) ) then
                        found = .true.
                        exit
                     end if
                  end do
                  if( .not. found ) then
                     print *, 'error: greek name: "', string(i+2:k-1),  &
                              '" not found in table.'
                     return
                  end if
                  if( j <= 24 ) then
                     ! first part:  upper case
                     c = char( greek_ind(j) )
                  else if( j >= 49 ) then
                     if( j == 49 ) then
                        c = "J"
                     else if( j == 50 ) then
                        c = "v"
                     else if( j == 51 ) then
                        c = "V"
                     else if( j == 52 ) then
                        c = "f"
                     end if
                  else
                     ! second part: lower case
                     c = char( greek_ind(j-24)+32 )
                  end if
                  old_fontcode = fontcode
                  fontcode = "g"
                  call ps_font_char_width( ichar(c), fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  i_mem = i_mem + 1
                  width_mem(i_mem) = width
                  i_back = i_mem
                  call send_few_chars( c, 1, UTF8=.false. )
                  fontcode = old_fontcode
                  i = k + 1
                  cycle
               case( "g" )
                  !  short escaped sequence for a greek letter
                  if( i+2 > n ) then
                     call PrintMessage( "grlen_xft", "W",               &
                                        "parsing your string: '" // string // "'", &
                                        "got an error at: '" // string(i:) // "'", &
                                        "found '\g' so a greek equivalent letter is expected." )
                     return
                  end if
                  c = string(i+2:i+2)
                  old_fontcode = fontcode
                  fontcode = "g"
                  call ps_font_char_width( ichar(c), fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  i_mem = i_mem + 1
                  width_mem(i_mem) = width
                  i_back = i_mem
                  buf_start = i+2
                  buf_len = 1
                  call flush_buffer()
                  fontcode = old_fontcode
                  i = i + 3
                  cycle
               case( "A" )
                  call ps_font_char_width( 197, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  i_mem = i_mem + 1
                  width_mem(i_mem) = width
                  i_back = i_mem
                  call send_few_chars( "Å", 2, UTF8=.true. ) ! Aring (C 197)
                  i = i + 2
                  cycle
               case( "x" )
                  call ps_font_char_width( 215, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  i_mem = i_mem + 1
                  width_mem(i_mem) = width
                  i_back = i_mem
                  call send_few_chars( "×", 2, UTF8=.true. ) ! multiply (C 215)
                  i = i + 2
                  cycle
               case( "." )
                  call ps_font_char_width( 183, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  i_mem = i_mem + 1
                  width_mem(i_mem) = width
                  i_back = i_mem
                  call send_few_chars( "·", 2, UTF8=.true. ) ! periodcentered (C 183)
                  i = i + 2
                  cycle
               case( "1" )
                  call ps_font_char_width( 185, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  i_mem = i_mem + 1
                  width_mem(i_mem) = width
                  i_back = i_mem
                  call send_few_chars( "¹", 2, UTF8=.true. ) ! onesuperior (C 185)
                  i = i + 2
                  cycle
               case( "2" )
                  call ps_font_char_width( 178, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  i_mem = i_mem + 1
                  width_mem(i_mem) = width
                  i_back = i_mem
                  call send_few_chars( "²", 2, UTF8=.true. ) ! twosuperior (C 178)
                  i = i + 2
                  cycle
               case( "3" )
                  call ps_font_char_width( 179, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  i_mem = i_mem + 1
                  width_mem(i_mem) = width
                  i_back = i_mem
                  call send_few_chars( "³", 2, UTF8=.true. ) ! threesuperior (C 179)
                  i = i + 2
                  cycle
               case( "\" )
                  call ps_font_char_width( 92, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  i_mem = i_mem + 1
                  width_mem(i_mem) = width
                  i_back = i_mem
                  call send_few_chars( "\", 1, UTF8=.false. ) ! backslash (C 92)
                  i = i + 2
                  cycle
               case( "-" )
                  ! "minus" en mode math, ou "endash"
                  call ps_font_char_width( 29, fontcode, width )
                  width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
                  i_mem = i_mem + 1
                  width_mem(i_mem) = width
                  i_back = i_mem
                  call send_few_chars( "–", 3, UTF8=.true. ) ! endash (C 29)
                  i = i + 2
                  cycle
               case default
                  call guess_greek_letter( string(i:), guess )
                  if( len_trim(guess) > 0 ) then
                     call PrintMessage( "grlen_xft", "W",               &
                                        "interpreting your string: '" // string // "'", &
                                        "got an error at: '" // string(i:) // "'", &
                                        "found one backslash but don't understand the following characters: '"//string(i+1:i+2)//"'", &
                                        "Did you thought about '" // trim(guess) // "'?" )
                  else
                     call PrintMessage( "grlen_xft", "W",               &
                                        "interpreting your string: '" // string // "'", &
                                        "got an error at: '" // string(i:) // "'", &
                                        "found one backslash but don't understand the following characters: '"//string(i+1:i+2)//"'" )
                  end if
                  i = i + 3
                  cycle
            end select
         else
            call PrintMessage( "grlen_xft", "W",                        &
                               "parsing your string: '" // string // "'", &
                               "got an error at: '" // string(i:) // "'", &
                               "found one backslash but nothing after...", &
                               "did you thought about '\\'?" )
            return
         end if
      else

         call ps_font_char_width( ichar(string(i:i)), fontcode, width )
!### TODO: Warning: le facteur 1.03 (empirique) ci-dessous, sert  avoir
!          le bon espacement entre les groupes de lettres, par comparaison
!          avec la chane crite d'un seul coup !
!### TODO: mais cela dpend de la taille de la fentre X11 (j'ai test)
!          =========>  corriger !
         width = width * ps_font_size*fontmul(fontcode)*FNTFAC * 1.03d0
         i_mem = i_mem + 1
         width_mem(i_mem) = width
         i_back = i_mem

         ! fill buffer
         if( buf_len == 0 ) then
            buf_start = i
         end if
         buf_len = buf_len + 1

         i = i + 1
      end if

   end do

contains
!_______________________________________________________________________
!
   subroutine flush_buffer( )

      character(len=80) :: fontname
      integer :: string_utf8, i

      if( buf_len > 0 ) then

         write(fontname,"(F7.2)") font_size*fontmul(fontcode)*FNTFAC
         i = index( fontname, "*" )
         if(i /= 0 ) then
            call grwarn('(Muesli FGL:) grlen_xft: marker scale too large!')
            print *, "  -> unexpected results may occur..."
         end if
         fontname = adjustl(fontname)
         select case( fontcode )
            case( "n" )
               fontname = "Helvetica-" // fontname
            case( "N" )
               fontname = "Helvetica-" // trim(fontname) // ":Bold"
            case( "i" )
               fontname = "Times-" // trim(fontname) // ":Italic"
            case( "I" )
               fontname = "Times-" // trim(fontname) // ":Bold:Italic"
            case( "r" )
               fontname = "Times-" // fontname
            case( "R" )
               fontname = "Times-" // trim(fontname) // ":Bold"
            case( "g" )
               fontname = "Symbol-" // fontname
            case( "s" )
               fontname = "English 157-" // fontname
            case default
               print *, "(Muesli FGL:) Internal error: unknown fontcode"
               return
         end select

         ! Send the font (name and attributes)
         chr = trim(fontname) // char(0)
         lchr = len_trim(fontname) + 1
         ibuf(1) = 0 ! ISO-8859-1, not UTF-8
         call grexec( grgtyp, SET_FONT_XFT, rbuf, ibuf, chr, lchr )

         ! Send a part of the string and its position
         chr = string(buf_start:buf_start+buf_len-1) // char(0)
         lchr = buf_len + 1
         call grexec( grgtyp, GET_XFT_STRING_BBOX, rbuf, ibuf, chr, lchr )
         s_width = max( s_width, rbuf(3) )
         s_h_min = max( s_h_min, rbuf(4) )
         s_h_max = min( s_h_max, rbuf(2) )

         ! next position: cumulate last widths
         dx = sum( width_mem(i_mem-(buf_len-1):i_mem) )
         call rmoveto( dx, 0.0d0 )

         buf_len = 0

      end if

   end subroutine flush_buffer
!_______________________________________________________________________
!
   subroutine send_few_chars( s, s_len, utf8 )

      character(len=*), intent(in)           :: s
      integer,          intent(in)           :: s_len
      logical,          intent(in), optional :: utf8
      !------ API end ------

      ! default: utf8=0 (=> ISO-8859-1)

      character(len=80) :: fontname
      integer :: string_utf8, i

      if( present(utf8) ) then
         if( utf8 ) then
            string_utf8 = 1
         else
            string_utf8 = 0
         end if
      else
         string_utf8 = 0
      end if

      write(fontname,"(F7.2)") font_size*fontmul(fontcode)*FNTFAC
      i = index( fontname, "*" )
      if(i /= 0 ) then
         call grwarn('(Muesli FGL:) grlen_xft: marker scale too large!')
         print *, "  -> unexpected results may occur..."
      end if
      fontname = adjustl(fontname)
      select case( fontcode )
         case( "n" )
            fontname = "Helvetica-" // fontname
         case( "N" )
            fontname = "Helvetica-" // trim(fontname) // ":Bold"
         case( "i" )
            fontname = "Times-" // trim(fontname) // ":Italic"
         case( "I" )
            fontname = "Times-" // trim(fontname) // ":Bold:Italic"
         case( "r" )
            fontname = "Times-" // fontname
         case( "R" )
            fontname = "Times-" // trim(fontname) // ":Bold"
         case( "g" )
            fontname = "Symbol-" // fontname
         case( "s" )
            fontname = "English 157-" // fontname
      end select

      ! Send the font (name and attributes)
      chr = trim(fontname) // char(0)
      lchr = len_trim(fontname) + 1
      ibuf(1) = string_utf8
      call grexec( grgtyp, SET_FONT_XFT, rbuf, ibuf, chr, lchr )

      ! Send the character and its position
      chr = trim(s) // char(0)
      lchr = s_len + 1
      call grexec( grgtyp, GET_XFT_STRING_BBOX, rbuf, ibuf, chr, lchr )
!!print *, "*** grlen_xft: send_few_chars: NOT READY"
!!      s_width = max( s_width, rbuf(3) )
!!      s_h_min = max( s_h_min, rbuf(4) )
!!      s_h_max = min( s_h_max, rbuf(2) )

      ! next position: cumulate last widths
      dx = sum( width_mem(i_mem:i_mem) )
      call rmoveto( dx, 0.0d0 )

   end subroutine send_few_chars
!_______________________________________________________________________
!
   subroutine rmoveto( dx, dy )

      double precision, intent(in) :: dx, dy
      !------ API end ------

      x = x + dx
      y = y + dy

   end subroutine rmoveto
!_______________________________________________________________________
!
   double precision function fontmul( fontcode )

      character, intent(in) :: fontcode
      !------ API end ------

      ! additional multiplicative factor the the font size, in order
      ! to obtain approximately the same heights for letters (both
      ! in lower- or uppercase).
      !
      ! see: 'Relative_sizes.eps'

      if( fontcode == "n" .or. fontcode == "N" ) then
         fontmul = 0.85d0
      else if( fontcode == "i" .or. fontcode == "I" ) then
         fontmul = 1.00d0
      else if( fontcode == "r" .or. fontcode == "R" ) then
         fontmul = 1.00d0
      else if( fontcode == "g" ) then
         fontmul = 0.95d0
      else if( fontcode == "s" ) then
         fontmul = 1.33d0
      end if

   end function fontmul
!_______________________________________________________________________
!
   subroutine guess_greek_letter( string, guess )
      character(len=*), intent(in)  :: string
      character(len=11)             :: guess

      ! We try to find the origin of an error. Perhaps the user type
      ! '\alpha' instead of '\(alpha)' ? Same for other greek letters...

      integer :: i, n

      guess = ""

      if( string(1:1) /= "\" ) return

      n = len_trim(string)

      do i = 1, 52
         if( string(2:n) == greek_names(i)(1:n-1) ) then
            guess = "\(" // trim(greek_names(i)) // ")"
            return
         end if
      end do

   end subroutine guess_greek_letter
!_______________________________________________________________________
!
end subroutine
