subroutine GRLEN_PS_FONT( string, w )

   character(len=*), intent(in)  :: string
   double precision, intent(out) :: w
   !------ API end ------

   ! Computes the length of a string, expressed as device coordinates.

   ! Note: this routine is only called by PGLEN, which in turn is called
   !       only by few auxiliary routines of PGTBOX.

   ! As opposed to grparse_ps_font, a simpler parsing is done.
   ! Don't forget to set gr_minus_sign_math_mode=.true. if you want a
   ! math minus sign instead a simple dash.

   integer :: i, n, dash_length
   double precision :: width, h1, h2
   character :: c

   !------ end of declarations -- execution starts hereafter  ------

   ! trailing blanks are removed
   n = len_trim(string)

   i = 1
   w = 0.0

   do

      if( i >= n+1 ) then
         exit
      end if

      if( string(i:i) == "-" ) then
         ! hyphen
         dash_length = 1
         i = i + 1
         if( gr_minus_sign_math_mode ) then
            ! for writing numerical labels of axes, a minus in math mode
            ! is systematically used...
            dash_length = 2
         end if
         if( dash_length == 1 ) then
            ! A "hyphen" must use StandardEncoding, else it will be very
            ! long (as "minus" in math mode). To get a "minus" in math mode,
            ! use "\-" instead.
            call ps_font_char_width( 45, "n", width, h1, h2 )
            w = w + width * ps_font_size*0.85d0
         else ! dash_length == 2
            ! "minus" in math mode, or "endash"
            call ps_font_char_width( 29, "n", width, h1, h2 )
            w = w + width * ps_font_size*0.85d0
         end if
         cycle
      else
         call ps_font_char_width( ichar( string(i:i) ), "n", width, h1, h2 )
         w = w + width * ps_font_size*0.85d0
         i = i + 1
      end if
   end do

   ! fix a badly scaling (on X11)
   w = w * 1.04d0

end subroutine
