! GRCURS_DYN -- read cursor position, and change cursor dynamically
! GRCURS_DYN_QUAD -- idem GRCURS_DYN, for a quadrilateral polygon
! GRCURS_DYN_PLUS_EXCLUDE -- idem GRCURS_DYN, with an exclusion zone
! GRCURS_DYN_MULTISPOT -- idem GRCURS_DYN, using a multispot zone
!
! from GRCURS but adapted for PGBAND_DYN
!
integer function GRCURS_DYN( cursor, imin,imax,jmin,jmax,               &
                             ix, iy, ch,                                &
                             pg_xorg, pg_yorg, pg_xscl, pg_yscl,        &
                             axis_scale_x, axis_scale_y )

   integer :: cursor, imin, imax, jmin, jmax, ix, iy
   character(len=*) :: ch
   double precision, optional :: pg_xorg, pg_yorg, pg_xscl, pg_yscl
   integer, optional :: axis_scale_x, axis_scale_y
   !------ API end ------

   !--
   ! 20-Sep-2008 - new routine (comes from GRCURS) [É. Canot].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !  6-Jul-2021 - Added four parameter to convert dev coords to world
   !               coords (use inside the X11 driver only).
   !--------------------------------------------------------------------

   double precision :: rbuf(4)
   integer :: ibuf(12), lchr, icurs
   character(len=16) :: chr
   character :: c
   !------ end of declarations -- execution starts hereafter  ------

   ! Begin picture if necessary.
   if( .not.grpltd(grcide) ) call grbpic

   ! Does the device have a cursor?
   c = grgcap(grcide)(2:2)
   if( c == "C" .or. c == "X" ) then
      icurs = 1
   else
      icurs = 0
   end if

   ! Device does have a cursor.
   if( icurs > 0 ) then
      ! BBOX device coordinates
      ibuf(1) = imin
      ibuf(2) = imax
      ibuf(3) = jmin
      ibuf(4) = jmax
      !- cursor shape
      ibuf(5) = cursor
      ! scaling of axes
      if( present(pg_xorg) ) then
         ibuf(10) = 1 ! want the position output in the bottom-left corner
         rbuf(1) = pg_xorg
         rbuf(2) = pg_yorg
         rbuf(3) = pg_xscl
         rbuf(4) = pg_yscl
         if( present(axis_scale_x) ) then
            ibuf(11) = axis_scale_x ! 1=lin, 2=log
            ibuf(12) = axis_scale_y ! 1=lin, 2=log
         else
            ibuf(11) = 1
            ibuf(12) = 1
         end if
      else
         ibuf(10) = 0 ! don't want the position output in the bottom-left corner
      end if

      call grexec( grgtyp, READ_CURSOR_DYN, rbuf, ibuf, chr, lchr )
      ix = ibuf(1)
      iy = ibuf(2)
      ch = chr(1:1)
      grcurs_dyn = 1
      ! error if driver returns NULL
      if( ichar(ch) == 0 ) then
         grcurs_dyn = 0
      endif

   ! Other devices are illegal.
   else
      call grexec( grgtyp, GET_DEV_NAME, rbuf, ibuf, chr, lchr )
      lchr = index(chr," ")
      call grwarn( "Output device has no cursor: " // chr(:lchr) )
      ch = char(0)
      grcurs_dyn = 0
   end if

end function grcurs_dyn
!_______________________________________________________________________
!
integer function GRCURS_DYN_QUAD( cursor, ibox,jbox,                    &
                                  ix, iy, ch )

   integer :: cursor, ibox(4), jbox(4), ix, iy
   character(len=*) :: ch
   !------ API end ------

   !--
   ! 20-Sep-2008 - new routine (comes from GRCURS) [É. Canot].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !--------------------------------------------------------------------

   double precision :: rbuf(1)
   integer :: ibuf(9), lchr, icurs
   character(len=16) :: chr
   character :: c
   !------ end of declarations -- execution starts hereafter  ------

   ! Begin picture if necessary.
   if( .not.grpltd(grcide) ) call grbpic

   ! Does the device have a cursor?
   c = grgcap(grcide)(2:2)
   if( c == "C" .or. c == "X" ) then
      icurs = 1
   else
      icurs = 0
   end if

   ! Device does have a cursor.
   if( icurs > 0 ) then
      ! BBOX device coordinates
      ibuf(1:4) = ibox(:)
      ibuf(5:8) = jbox(:)
      !- cursor shape
      ibuf(9) = cursor

      call grexec( grgtyp, READ_CURSOR_DYN_QUADR_POLYG, rbuf, ibuf, chr, lchr )
      ix = ibuf(1)
      iy = ibuf(2)
      ch = chr(1:1)
      grcurs_dyn_quad = 1
      ! error if driver returns NULL
      if( ichar(ch) == 0 ) then
         grcurs_dyn_quad = 0
      endif

   ! Other devices are illegal.
   else
      call grexec( grgtyp, GET_DEV_NAME, rbuf, ibuf, chr, lchr )
      lchr = index(chr," ")
      call grwarn( "Output device has no cursor: " // chr(:lchr) )
      ch = char(0)
      grcurs_dyn_quad = 0
   end if

end function grcurs_dyn_quad
!_______________________________________________________________________
!
integer function GRCURS_DYN_PLUS_EXCLUDE( cursor,                       &
                             imin, imax, jmin, jmax,                    &
                             not_imin, not_imax, not_jmin, not_jmax,    &
                             ix, iy, ch,                                &
                             pg_xorg, pg_yorg, pg_xscl, pg_yscl,        &
                             axis_scale_x, axis_scale_y )

   integer :: cursor, imin, imax, jmin, jmax, ix, iy
   integer :: not_imin, not_imax, not_jmin, not_jmax
   character(len=*) :: ch
   double precision, optional :: pg_xorg, pg_yorg, pg_xscl, pg_yscl
   integer, optional :: axis_scale_x, axis_scale_y
   !------ API end ------

   !--
   ! 20-Sep-2008 - new routine (comes from GRCURS)
   ! 20-Jun-2016 - new routine (comes from GRCURS_DYN),
   !               which take into consideration an exclusion box.
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   !  6-Jul-2021 - Added four parameter to convert dev coords to world
   !               coords (use inside the X11 driver only).
   !--------------------------------------------------------------------

   double precision :: rbuf(4)
   integer :: ibuf(12), lchr, icurs
   character(len=16) :: chr
   character :: c
   !------ end of declarations -- execution starts hereafter  ------

   ! Begin picture if necessary.
   if( .not. grpltd(grcide) ) call grbpic

   ! Does the device have a cursor?
   c = grgcap(grcide)(2:2)
   if( c == "C" .or. c == "X" ) then
      icurs = 1
   else
      icurs = 0
   end if

   ! Device does have a cursor.
   if( icurs > 0 ) then
      ! BBOX device coordinates
      ibuf(1) = imin
      ibuf(2) = imax
      ibuf(3) = jmin
      ibuf(4) = jmax
      ! BBOX excluded device coordinates
      ibuf(5) = not_imin
      ibuf(6) = not_imax
      ibuf(7) = not_jmin
      ibuf(8) = not_jmax
      !- cursor shape
      ibuf(9) = cursor
      ! scaling of axes
      if( present(pg_xorg) ) then
         ibuf(10) = 1 ! want the position output in the bottom-left corner
         rbuf(1) = pg_xorg
         rbuf(2) = pg_yorg
         rbuf(3) = pg_xscl
         rbuf(4) = pg_yscl
         if( present(axis_scale_x) ) then
            ibuf(11) = axis_scale_x ! 1=lin, 2=log
            ibuf(12) = axis_scale_y ! 1=lin, 2=log
         else
            ibuf(11) = 1
            ibuf(12) = 1
         end if
      else
         ibuf(10) = 0 ! don't want the position output in the bottom-left corner
      end if

      call grexec( grgtyp, READ_CURSOR_DYN_EXCL_BOX, rbuf, ibuf, chr, lchr )
      ix = ibuf(1)
      iy = ibuf(2)
      ch = chr(1:1)
      grcurs_dyn_plus_exclude = 1
      ! error if driver returns NULL
      if( ichar(ch) == 0 ) then
         grcurs_dyn_plus_exclude = 0
      endif

   ! Other devices are illegal.
   else
      call grexec( grgtyp, GET_DEV_NAME, rbuf, ibuf, chr, lchr )
      lchr = index(chr," ")
      call grwarn( "Output device has no cursor: " // chr(:lchr) )
      ch = char(0)
      grcurs_dyn_plus_exclude = 0
   end if

end function grcurs_dyn_plus_exclude
!_______________________________________________________________________
!
integer function GRCURS_DYN_MULTISPOT( cursor,                          &
                                       ispot, jspot, nbspot, sel_spot,  &
                                       ix, iy, ch )

   integer :: cursor, ispot(*), jspot(*), nbspot, sel_spot, ix, iy
   character(len=*) :: ch
   !------ API end ------

   !--
   ! 14-Sep-2018 - new routine [É. Canot] (comes from GRCURS_DYN)
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !--------------------------------------------------------------------

   double precision :: rbuf(1)
   integer :: ibuf(2*nbspot+2), lchr, icurs
   character(len=16) :: chr
   character :: c
   integer :: k
   !------ end of declarations -- execution starts hereafter  ------

   ! Begin picture if necessary.
   if( .not. grpltd(grcide) ) call grbpic

   ! Does the device have a cursor?
   c = grgcap(grcide)(2:2)
   if( c == "C" .or. c == "X" ) then
      icurs = 1
   else
      icurs = 0
   end if

   ! Device does have a cursor.
   if( icurs > 0 ) then
      ibuf(1) = 2*nbspot + 1
      ! BBOX device coordinates
      do k = 1, nbspot
         ibuf(2*k) = ispot(k)
         ibuf(2*k+1)   = jspot(k)
      end do
      !- cursor shape
      ibuf(2*nbspot+2) = cursor

      call grexec( grgtyp, READ_CURSOR_DYN_MULTISPOT, rbuf, ibuf, chr, lchr )
      ix = ibuf(1)
      iy = ibuf(2)
      sel_spot = ibuf(3)
      ch = chr(1:1)
      grcurs_dyn_multispot = 1
      ! error if driver returns NULL
      if( ichar(ch) == 0 ) then
         grcurs_dyn_multispot = 0
      endif

   ! Other devices are illegal.
   else
      call grexec( grgtyp, GET_DEV_NAME, rbuf, ibuf, chr, lchr )
      lchr = index(chr," ")
      call grwarn( "Output device has no cursor: " // chr(:lchr) )
      ch = char(0)
      grcurs_dyn_multispot = 0
   end if

end function grcurs_dyn_multispot
