! GRCLOS_EC -- close graphics on X11 device

subroutine GRCLOS_EC( ibuf )

   integer, intent(out) :: ibuf(4)
   !------ API end ------

   ! GRPCKG: Close the open plot on the current device. Any pending output
   ! is sent to the device, the device or the disk file is closed, and no
   ! further plotting is allowed on the device without a new call to GROPEN.
   !
   ! Arguments:
   !   IBUF (output): position and size of the X11 window.
   !--
   !  1-Jun-1984 - [TJP].
   ! 17-Jul-1984 - ignore call if plot is not open [TJP].
   !  1-Oct-1984 - reset color to default (1) and position text cursor
   !               at bottom of VT screen [TJP].
   ! 19-Oct-1984 - add VV device [TJP].
   ! 22-Dec-1984 - use GRBUFL and GRIOTA parameters [TJP].
   !  5-Aug-1986 - add GREXEC support [AFT].
   ! 21-Feb-1987 - modify END_PICTURE sequence [AFT].
   ! 11-Jun-1987 - remove built-ins [TJP].
   ! 31-Aug-1987 - do not eject blank page [TJP].
   !
   !    Feb-2005 - Created from GRCLOS : argument ibuf(4) added to recover
   !               information of low level routines [EC].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   double precision :: rbuf(4)
   integer :: lchr
   character :: chr
   !------ end of declarations -- execution starts hereafter  ------

   ! Check that the plot is open.
   if( grcide < 1 ) return

   ! Reset color to default (1=foreground).
   call grsci(1)

   ! Flush buffer.
   call grterm

   ! End picture.
   call grepic

   ! This plot identifier is no longer in use.
   grstat(grcide) = 0

   ! Set state to "workstation closed".
   grcide = 0

   ! Close workstation.
   call grexec( grgtyp, CLOSE_DEV, rbuf, ibuf, chr, lchr )

end subroutine
