integer function gr_set_cursor_shape( ishape )

   integer, intent(in) :: ishape

   ! GR_SET_CURSOR_SHAPE: Change cursor shape.
   !         (see numbering in 'xw_set_cursor', and 'mod_win_db.F90')
   !
   ! Returns:
   !
   ! GR_SET_CURSOR_SHAPE (integer): 1 if the call was successful;
   !                                0 if the device has no cursor or
   !                                  some other error occurs.
   !
   !--
   ! 16-Dec-2007 - New routine. Communicate with xwdriv by ifunc=62.
   ! 12-Sep-2008 - Shift numbering of ishape in order to match those
   !               of PGBAND() (with a special case for num 2 and 3).
   !  4-Jul-2021 - New numbering of cursors.
   !--------------------------------------------------------------------

   double precision :: rbuf(1)
   integer :: ibuf(1), lchr, icurs
   character(len=16) :: chr
   character :: c
   !------ end of declarations -- execution starts hereafter  ------

   ! Begin picture if necessary.
   if( .not. grpltd(grcide) ) call grbpic

   ! Does the device have a cursor?
   c = grgcap(grcide)(2:2)
   icurs = 0
   if( c == "C" .or. c == "X" ) icurs = 1
   if( icurs > 0 ) then

      ! Device does have a cursor.
      ibuf(1) = ishape
      call grexec( grgtyp, SET_CURSOR_SHAPE, rbuf, ibuf, chr, lchr )
      gr_set_cursor_shape = 1

   else

      ! Other devices are illegal.
      call grexec( grgtyp, GET_DEV_NAME, rbuf, ibuf, chr, lchr )
      lchr = index(chr," ")
      call grwarn( "output device has no cursor: " // chr(:lchr) )
      gr_set_cursor_shape = 0

   end if

end function
