subroutine gr_read_AFM_files( )

   ! lecture dans des tableaux du module 'mod_grplot' des caractériques des
   ! caractères, pour les 8 polices PS utilisées.
   !--------------------------------------------------------------------

   character(len=256) :: path
   character(len=290) :: font_path
   character(len=80)  :: fontname(8)

   integer :: i_font, i_char, L, bbox(4)
   logical :: exist, found
   character(len=132) :: line
   !------ end of declarations -- execution starts hereafter  ------

   ! get the Muesli installation directory
   if( MFPLOT_DIR == "" ) then
      call set_muesli_install_dir_fgl()
   end if
   path = MFPLOT_DIR
   path = trim(path) // "/fontconfig/fonts"

   fontname(1) = "/Helvetica_ISOLatin1.afm"                   ! \fn
   fontname(2) = "/Helvetica-Bold_ISOLatin1.afm"              ! \fN
   fontname(3) = "/Times-Italic_ISOLatin1.afm"                ! \fi
   fontname(4) = "/Times-BoldItalic_ISOLatin1.afm"            ! \fI
   fontname(5) = "/Times-Roman_ISOLatin1.afm"                 ! \fr
   fontname(6) = "/Times-Bold_ISOLatin1.afm"                  ! \fr
   fontname(7) = "/Symbol.afm"                                ! greek
   fontname(8) = "/English157BT-Regular-subset_ISOLatin1.afm" ! \fs

   font_metrics(:,:) = -1

   !-----------

   do i_font = 1, 8

      font_path = trim(path) // fontname(i_font)
      inquire( file=trim(font_path), exist=exist )
      if( .not. exist ) then
         call grwarn(                                                      &
            "PostScript AFM file: " // trim(font_path) // " not found!" )
         stop
      end if

      open( 10, file=trim(font_path), status="old" )

      ! looking for "FontBBox" in the AFM file...
      found = .false.
      do
         read( 10, "(A)", end=99 ) line
         if( line(1:8) == "FontBBox" ) then
            found = .true.
            exit
         end if
      end do
      if( .not. found ) then
         print *, "(MUESLI:) Error in 'gr_read_AFM_files'"
         print *, "searching in PostScript AFM file: " // trim(font_path)
         call grwarn( "'FontBBox' tag not found!" )
         stop
      end if

      ! read font heights from BBox
      read( line(9:), * ) bbox(1:4)
      font_heights( i_font, 1 ) = bbox(2)/1000. ! h_min
      font_heights( i_font, 2 ) = bbox(4)/1000. ! h_max

      ! looking for "StartCharMetrics" in the AFM file...
      found = .false.
      do
         read( 10, "(A)", end=99 ) line
         if( line(1:16) == "StartCharMetrics" ) then
            found = .true.
            exit
         end if
      end do
      if( .not. found ) then
         print *, "(MUESLI:) Error in 'gr_read_AFM_files'"
         print *, "searching in PostScript AFM file: " // trim(font_path)
         call grwarn( "'StartCharMetrics' tag not found!" )
         stop
      end if

      if( i_font == 7 ) then
         ! exception for the Symbol font
         do i_char = 32, 126
            read( 10, "(A)", end=99 ) line
            read( line(12:15), * ) font_metrics( i_font, i_char )
         end do
         do i_char = 160, 254
            read( 10, "(A)", end=99 ) line
            read( line(12:15), * ) font_metrics( i_font, i_char )
         end do
      else if( i_font == 8 ) then
         ! exception for the English157BT font
         i_char = 32
         read( 10, "(A)", end=99 ) line
         read( line(12:15), * ) font_metrics( i_font, i_char )
         do i_char = 65, 90
            read( 10, "(A)", end=99 ) line
            read( line(12:15), * ) font_metrics( i_font, i_char )
         end do
         do i_char = 97, 122
            read( 10, "(A)", end=99 ) line
            read( line(12:15), * ) font_metrics( i_font, i_char )
         end do
      else
         do i_char = 22, 255
            read( 10, "(A)", end=99 ) line
            read( line(12:15), * ) font_metrics( i_font, i_char )
         end do
      end if

      close( 10 )

   end do

   !-----------

   return

 99 continue
   print *, "(MUESLI:) Error in 'gr_read_AFM_files'"
   print *, "while reading in PostScript AFM file: " // trim(font_path)
   call grwarn( "EndOfFile occured!" )
   stop

end subroutine
