subroutine EMBED_EnglishBT_PFA()

   character(len=256) :: path
   integer :: k
   logical :: exist, success
   character(len=132) :: line
   !------ end of declarations -- execution starts hereafter  ------

   ! get the Muesli installation directory
   if( MFPLOT_DIR == "" ) then
      call set_muesli_install_dir_fgl()
   end if
   path = MFPLOT_DIR

   ! check that the PostScript PFA file is found
   path = trim(path) // "/fontconfig/fonts/englishBT-reg_subset.pfa"
   inquire( file=trim(path), exist=exist )
   if( .not. exist ) then
      call grwarn(                                                      &
           "PostScript Font file: " // trim(path) // " not found!" )
      return
   end if

   call gresc( "" )
   call gresc( "%%BeginFont: English157BT-Regular (subset)" )

   ! read all the PFA file and insert it in the PS file...
   ! two light checks:
   !   1) some subtrings value in the last line of the hexadecimal block
   !   2) the total number of lines read
   open( 10, file=trim(path), status="old" )
   success = .true.
   k = 0 ! counting the lines
   do
      read( 10, "(A)", end=99 ) line
      k = k + 1
      if( k == 275 ) then
         if( line(1:6) /= "0df5e8" .or. line(75:80) /= "a01335" ) then
            success = .false.
         end if
      end if
      call gresc( trim(line) )
   end do

99 continue

   close( 10 )
   if( .not. success ) then
      ! Something is wrong in data. Font file corrupted?
      print *, "(Muesli FGL:) EPS driver: Cannot embed the Script Font!"
      print *, "              Read succeeded, but last line of the hexa block is wrong."
      print *, "              Corrupted file?"
      print *, "              Characters using the script font will not appear as expected..."
      pause "only for debugging purpose"
   end if
   if( k /= 280 ) then
      ! Something is wrong in data. Font file corrupted?
      print *, "(Muesli FGL:) EPS driver: Cannot embed the Script Font!"
      print *, "              Read succeeded, but line number is wrong."
      print *, "              Corrupted file?"
      print *, "              Characters using the script font will not appear as expected..."
      pause "only for debugging purpose"
   end if
   call gresc( "%%EndFont" )
   call gresc( "" )

end subroutine
