subroutine CHANGE_VIEWPORT( bbox, bbox_save )

   double precision, intent(in)  :: bbox(4)
   double precision, intent(out) :: bbox_save(4)
   !------ API end ------

   ! Change viewport values in mod_grplot.
   !
   !  Input:
   !    BBOX: Viewport values in world coordinates
   !
   !  Ouput:
   !    BBOX_SAVE: current values (in device coords) for a later restore
   !--
   ! ??-???-???? - Création by É. Canot
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !--------------------------------------------------------------------

   !------ end of declarations -- execution starts hereafter  ------

   ! First save current values
   bbox_save(1) = grxmin(grcide)
   bbox_save(2) = grymin(grcide)
   bbox_save(3) = grxmax(grcide)
   bbox_save(4) = grymax(grcide)

   ! Change viewport values
   ! translate to device coords (input are world coords).
   grxmin(grcide) = bbox(1)*grxscl(grcide) + grxorg(grcide)
   grymin(grcide) = bbox(2)*gryscl(grcide) + gryorg(grcide)
   grxmax(grcide) = bbox(3)*grxscl(grcide) + grxorg(grcide)
   grymax(grcide) = bbox(4)*gryscl(grcide) + gryorg(grcide)

end subroutine
