! PGWNAD -- Set window and adjust viewport to same aspect ratio

subroutine PGWNAD( x1, x2, y1, y2 )

   double precision, intent(in) :: x1, x2, y1, y2

   ! Change the window in world coordinate space that is to be mapped on
   ! to the viewport, and simultaneously adjust the viewport so that the
   ! world-coordinate scales are equal in x and y. The new viewport is
   ! the largest one that can fit within the previously set viewport
   ! while retaining the required aspect ratio.
   !
   ! Arguments:
   !  X1     (input)  : the x-coordinate of the bottom left corner
   !                    of the viewport.
   !  X2     (input)  : the x-coordinate of the top right corner
   !                    of the viewport (note X2 may be less than X1).
   !  Y1     (input)  : the y-coordinate of the bottom left corner
   !                    of the viewport.
   !  Y2     (input)  : the y-coordinate of the top right corner of the
   !                    viewport (note Y2 may be less than Y1).
   !--
   ! 25-Sep-1985 - New routine (TJP).
   ! 31-May-1989 - Correct error: XVP and YVP not set (TJP).
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   ! 16-Apr-2020 - Modified to take into account suppression of panels [EC].
   !-----------------------------------------------------------------------

   double precision :: scale, oxlen, oylen

   !------ end of declarations -- execution starts hereafter  ------

   ! If invalid arguments are specified, issue warning and leave window
   ! unchanged.

   if( x1 == x2 ) then
      call grwarn('invalid x limits in PGWNAD: X1 = X2.')
   else if( y1 == y2 ) then
      call grwarn('invalid y limits in PGWNAD: Y1 = Y2.')
   else
      scale = min(pgxlen(pgid)/abs(x2-x1)/pgxpin(pgid),              &
                  pgylen(pgid)/abs(y2-y1)/pgypin(pgid))
      pgxscl(pgid) = scale*pgxpin(pgid)
      pgyscl(pgid) = scale*pgypin(pgid)
      oxlen = pgxlen(pgid)
      oylen = pgylen(pgid)
      pgxlen(pgid) = pgxscl(pgid)*abs(x2-x1)
      pgylen(pgid) = pgyscl(pgid)*abs(y2-y1)
      pgxvp(pgid)  = pgxvp(pgid) + 0.5d0*(oxlen-pgxlen(pgid))
      pgyvp(pgid)  = pgyvp(pgid) + 0.5d0*(oylen-pgylen(pgid))
      call pgswin( x1, x2, y1, y2 )
   end if

end subroutine
