! PGVW -- Set scaling and window

subroutine PGVW

   ! MFPLOT (internal routine): set the GRPCKG scaling transformation
   ! and window appropriate for the current window and viewport. This
   ! routine is called whenever the viewport or window is changed.
   !
   ! Arguments: none. But uses the BBOX pgxtrc, pgxtrc, pgyblc, pgytrc,
   !            stored as global variables in mod_pgplot.
   !
   ! (11-Feb-1983)
   ! 15-Apr-2020 - Removed call to GRTRN0.
   ! 16-Apr-2020 - Modified to take into account suppression of panels.
   ! 17-Apr-2020 - Simplify the computation of scaling (algebraic).
   !-----------------------------------------------------------------------

   ! Scale plotter in world coordinates.
   ! (may have negative values if axes are inverted)
   pgxscl(pgid) = pgxlen(pgid)/(pgxtrc(pgid)-pgxblc(pgid))
   pgyscl(pgid) = pgylen(pgid)/(pgytrc(pgid)-pgyblc(pgid))

   pgxorg(pgid) = pgxvp(pgid) - pgxblc(pgid)*pgxscl(pgid)
   pgyorg(pgid) = pgyvp(pgid) - pgyblc(pgid)*pgyscl(pgid)

   ! Scaling transformation, defined by:
   !               XABS = XORG + XWORLD*XSCALE,
   !               YABS = YORG + YWORLD*YSCALE,
   ! between absolute device coordinates (XABS, YABS) and
   ! world coordinates (XWORLD, YWORLD).
   grxorg(grcide) = pgxorg(pgid)
   gryorg(grcide) = pgyorg(pgid)
   grxscl(grcide) = pgxscl(pgid)
   gryscl(grcide) = pgyscl(pgid)

   ! Window plotter in viewport.
   call grarea( pgxvp(pgid), pgyvp(pgid),                               &
                pgxlen(pgid), pgylen(pgid) )

end subroutine
