! PGTIKL -- Length of error bar terminal

subroutine PGTIKL( t, xl, yl )

   double precision :: t, xl, yl

   ! Return the length of the terminal of an error bar, in world
   ! coordinates.
   !
   ! Arguments:
   !  T      (input)  : terminal multiplier
   !  XL     (output) : terminal length in world x-coordinates
   !  YL     (output) : terminal length in world y-coordinates
   !--
   ! 31-Mar-1997 - New routine [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   xl = t*pgxsp(pgid)*0.15d0/pgxscl(pgid)
   yl = t*pgxsp(pgid)*0.15d0/pgyscl(pgid)

end subroutine
