! PGTBX7 -- Support routine for PGTBOX

subroutine PGTBX7( suptyp, signf, asign, ival, rval, writ,              &
                   sprec, do2, text, tlen, last )

   double precision :: rval
   integer :: ival(3), tlen, sprec, last
   character :: asign*1, text*(*), signf*1, suptyp*4
   logical :: writ(4), do2

   ! Write (DD) HH MM SS.S time labels into a string
   !
   ! This is a support routine for PGTBOX and should not be
   ! called by the user
   !
   ! Inputs
   !  SUPTYP :  '    ', 'DHMS', or ' DMS' for no superscript labelling,
   !            d,h,m,s   or   o,','' superscripting
   !  SIGNF  :  Tells which field the sign is associated with.
   !            One of 'D', 'H', 'M', or 'S'
   !  ASIGN  :  ' ' or '-' for positive or negative times
   !  IVAL(3):  Day, hour, minutes of time
   !  RVAL   :  Seconds of time
   !  WRIT(4):  If TRUE then write DD, HH, MM, SS  into label
   !  SPREC  :  Number of places after the decimal to write seconds
   !            string to.  Must be in the range 0-3
   !  DO2    :  If true, add a leading zero to numbers < 10
   ! Outputs
   !  TEXT   :  Label
   !  TLEN   :  Length of label
   !  LAST   :  Is the location of the start character of the last
   !            field written into TEXT
   !
   ! 05-Sep-1989 - New routine (Neil Killeen)
   ! 20-Apr-1991 - Complete rewrite; support for new DD (day) field and
   !               superscripted labels [nebk]
   ! 14-May-1991 - Removed BSL as a parameter (Char(92)) and made it
   !               a variable to appease Cray compiler [mjs/nebk]
   ! 10-Jun-1993 - Rename from PGTLB1, add code to label superscript
   !               seconds above the '.' and add DO2 option [nebk/jm]
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer :: flen, fst, fmax, trlen(3), suppnt, tmpnt, tlen2, ir1, ir2, ip
   character :: field*30, frmat2(3)*2, super(4,3)*11, tmp*100, bsl*1, frmat*30

   save frmat2
   save trlen

   data frmat2 /'I1', 'I2', 'I3'/
   data trlen /5, 11, 5/

   !------ end of declarations -- execution starts hereafter  ------

   ! Initialize
   bsl = char(92)
   tlen = 0
   text = ' '

   ! Assign superscripting strings.  Use CHAR(92) for backslash as the
   ! latter must be escaped on SUNs thus requiring preprocessing.  The
   ! concatenator operator precludes the use of a data statement
   super(1,1) = bsl//'ud'//bsl//'d'
   super(2,1) = bsl//'uh'//bsl//'d'
   super(3,1) = bsl//'um'//bsl//'d'
   super(4,1) = bsl//'us'//bsl//'d'

   super(1,2) = bsl//'u'//bsl//'(2199)'//bsl//'d'
   super(2,2) = bsl//'u'//bsl//'(2729)'//bsl//'d'
   super(3,2) = bsl//'u'//bsl//'(2727)'//bsl//'d'
   super(4,2) = bsl//'u'//bsl//'(2728)'//bsl//'d'

   super(1,3) = bsl//'u'//' '//bsl//'d'
   super(2,3) = bsl//'u'//' '//bsl//'d'
   super(3,3) = bsl//'u'//' '//bsl//'d'
   super(4,3) = bsl//'u'//' '//bsl//'d'

   ! Point at correct superscript strings
   if( suptyp == 'DHMS' ) then
     suppnt = 1
   else if( suptyp == ' DMS' ) then
     suppnt = 2
   else
     suppnt = 3
   end if

   !=============
   ! Days field
   !=============
   if( writ(1) ) then
      last = tlen + 1

      ! write into temporary field
      field = ' '
      call pgnpl( 0, ival(1), flen )
      write( field, '(I6)' ) ival(1)
      fmax = 6
      fst = fmax - flen + 1

      ! Write output text string with desired superscripting
      tmpnt = 2
      if( signf == 'D' .and. asign /= ' ' ) tmpnt = 1

      tmp = asign//field(fst:fmax)//super(1,suppnt)
      tlen2 =( 2 - tmpnt) + flen + trlen(suppnt)

      text(tlen+1:) = tmp(tmpnt:tmpnt+tlen2-1)
      tlen = tlen + tlen2
   end if

   !=============
   ! Hours field
   !=============
   if( writ(2) ) then
      last = tlen + 1

      ! Write into temporary field
      field = ' '
      call pgnpl( 0, ival(2), flen )
      write( field, '(I6)' ) ival(2)
      fmax = 6
      fst = fmax - flen + 1

      if( do2 .and. flen == 1 ) then
         flen = flen + 1
         fst = fst - 1
         field(fst:fst) = '0'
      end if

      ! Write output text string with desired superscripting
      tmpnt = 2
      if( signf == 'H' .and. asign /= ' ' ) tmpnt = 1

      tmp = asign//field(fst:fmax)//super(2,suppnt)
      tlen2 = (2 - tmpnt) + flen + trlen(suppnt)

      text(tlen+1:) = tmp(tmpnt:tmpnt+tlen2-1)
      tlen = tlen + tlen2
   end if

   !=============
   ! Minutes field
   !=============
   if( writ(3) ) then
      last = tlen + 1

      ! Write into temporary field with desired superscripting
      field = ' '
      write( field, '(I2, A)' ) ival(3),                                &
                                super(3,suppnt)(1:trlen(suppnt))
      fmax = 2 + trlen(suppnt)

      fst = 1
      if( field(fst:fst) == ' ' ) then
         if( do2 ) then
            field(fst:fst) = '0'
         else
            fst = fst + 1
         end if
      end if
      flen = fmax - fst + 1

      ! Write output text string
      tmpnt = 2
      if( signf == 'M' .and. asign /= ' ' ) tmpnt = 1

      tmp = asign//field(fst:fmax)
      tlen2 = (2 - tmpnt) + flen

      text(tlen+1:) = tmp(tmpnt:tmpnt+tlen2-1)
      tlen = tlen + tlen2
   end if

   !=============
   ! Seconds field
   !=============
   if( writ(4) ) then
      last = tlen + 1

      ! Write into temporary field
      field = ' '
      fst = 1
      if( sprec >= 1 ) then

         ! Fractional label.  Upto 3 places after the decimal point allowed
         ! Muck around to get the superscript on top of the decimal point
         ir1 = int(rval)
         ir2 = nint((rval - ir1) * 10**sprec)
         frmat = '(I2, A1, A, '//frmat2(sprec)//')'
         write( field, frmat(1:15) ) ir1, '.',                          &
                                     bsl//'b'//super(4,suppnt)(1:trlen(suppnt)), &
                                     ir2
         ip = 5 + trlen(suppnt) + 1
         if( field(ip:ip) == ' ' ) field(ip:ip) = '0'
         if( field(ip+1:ip+1) == ' ' ) field(ip+1:ip+1) = '0'
         fmax = 1 + 2 + sprec
      else

         ! Integer label.
         write( field, '(I2,A)' ) nint(rval),                           &
                               super(4,suppnt)(1:trlen(suppnt))
         fmax = 0
      end if
      fmax = fmax + 2 + trlen(suppnt)

      if( field(fst:fst) == ' ' ) then
         if( do2 ) then
            field(fst:fst) = '0'
         else
            fst = fst + 1
         end if
      end if
      flen = fmax - fst + 1

      ! Write output text string
      tmpnt = 2
      if( signf == 'S' .and. asign /= ' ' ) tmpnt = 1
      tmp = asign//field(fst:fmax)
      tlen2 = (3 - tmpnt) + flen

      text(tlen+1:) = tmp(tmpnt:tmpnt+tlen2-1)
      tlen = tlen + tlen2
   end if

   ! A trailing blank will occur if no superscripting wanted
   if( tlen >= 5 .and. text(tlen-4:tlen) == bsl//'u'//' '//bsl//'d' ) then
      tlen = tlen - 5
   end if

end subroutine
