! PGTBX6 -- Support routine for PGTBOX

subroutine PGTBX6( doday, mod24, tscale, dd, hh, mm, ss, ival,          &
                   rval, writ )

   integer :: tscale, ival(3), dd, hh, mm
   double precision :: ss, rval
   logical :: writ(4), doday, mod24

   !  Find out which of the DD HH MM SS.S fields we want to write
   !  into the label according to TSCALE and make a round off
   !  error check.
   !
   ! Input:
   !   DODAY  :  Use day field if .true. else hours accrue beyond 24
   !   MOD24  :  HH field labelled as modulo 24
   !   TSCALE :  Dictates which fields appear in labels
   !   DD     :  Day of time  (will be 0 if DODAY=F and HH will compensate
   !   HH     :  Hour of time
   !   MM     :  Minute of time
   !   SS     :  Second of time
   ! Output:
   !   IVAL(3):  DD HH MM to write into label
   !   RVAL   :  SS.S to write into label
   !   WRIT(4):  T or F if DD,HH,MM,SS are to be written into the label
   !             or not.  IVAL and RVAL fields are set explicitly to
   !             zero if the corresponding WRIT field is .false..
   !             This really is overkill.
   !
   ! 10-Jun-1993 - New routine [nebk]
   ! 16-Jan-1995 - Add argument MOD24
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer :: wm

   !------ end of declarations -- execution starts hereafter  ------

   ival(1) = dd
   ival(2) = hh
   ival(3) = mm
   rval    = ss

   ! SS should be 0.0; round off may get us 59.999 or the like but
   ! not 60.001 (see PGTBX5)
   if( tscale > 1 ) then
      wm = nint(ss/60.0)
      ival(3) = ival(3) + wm
      if( ival(3) == 60 ) then
         ival(3) = 0
         ival(2) = ival(2) + 1
         if( doday .and. ival(2) == 24 ) then
            ival(2) = 0
            ival(1) = ival(1) + 1
         end if
      end if
   end if

   ! Make HH field modulo 24 if desired
   if( mod24 ) ival(2) = mod(ival(2),24)

   if( tscale == 1 ) then
      !  Label contains (DD) HH MM SS.S
      writ(1) = doday
      writ(2) = .true.
      writ(3) = .true.
      writ(4) = .true.
   else if( tscale == 60 ) then
      !  Label contains (DD) HH MM
      writ(1) = doday
      writ(2) = .true.
      writ(3) = .true.

      rval    = 0.0
      writ(4) = .false.
   else if( tscale == 3600 ) then
      !  Label contains (DD) HH
      writ(1) = doday
      writ(2) = .true.

      ival(3) = 0
      writ(3) = .false.

      rval    = 0.0
      writ(4) = .false.
   else if( tscale == 3600*24 ) then
      !  Label contains DD
      writ(1) = .true.

      ival(2) = 0
      writ(2) = .false.

      ival(3) = 0
      writ(3) = .false.

      rval    = 0.0
      writ(4) = .false.
   end if

end subroutine
