! PGTBX5 -- Support routine for PGTBOX

subroutine PGTBX5( doday, tsec, asign, d, h, m, s )

   double precision :: s, tsec
   integer :: d, h, m
   logical :: doday
   character*1 :: asign

   !  Convert time in seconds to (DD) HH MM SS.S
   !
   ! Input
   !  DODAY  :  Use day field if true, else hours accumulates beyond 24
   !  TSEC   :  Time in seconds (signed)
   ! Output
   !  ASIGN  :  Sign, ' ' or '-'
   !  D,H,M  :  DD, HH, MM (unsigned)
   !  S      :  SS.S       (unsigned)
   !
   ! 10-Jun-1993 - New routine [nebk]
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer :: it

   !------ end of declarations -- execution starts hereafter  ------

   asign = ' '
   if( tsec < 0.0d0 ) asign = '-'

   s = mod(abs(tsec),60.0d0)

   it = nint(abs(tsec)-s) / 60
   m = mod(it,60)

   it = (it - m) / 60
   if( doday ) then
      h = mod(it,24)
      d = (it-h) / 24
   else
      h = it
      d = 0
   end if

end subroutine
