! PGTBX3 -- Support routine for PGTBOX

subroutine PGTBX3( doday, npl, tscale, tints, nticmx, nticks,           &
                   ticks, nsubs, itick, axis, dopara, str, tick, nsub )

   integer :: tscale, nticmx, nticks, itick, nsub, nsubs(nticks), npl
   double precision :: tints, ticks(nticks), tick
   character :: axis*1, str*(*)
   logical :: doday, dopara

   ! Try to see if label overwrite is going to occur with this tick selection,
   ! or if there are going to be more than a reasonable number of ticks in
   ! the displayed time range.  If so, choose, if available, the next tick
   ! (bigger separation) up in the list. If the overwrite requires that we
   ! would need to go up to the next TSCALE, give up.  They will need to
   ! choose a smaller character size
   !
   ! This is a support routine for PGTBOX and should not
   ! be called by the user.
   !
   ! Input:
   !  DODAY  :  TRUE if day field being used
   !  NPL    :  Number of characters needed to format TICK on input
   !  TSCALE :  Dictates what the finest units of the labelling are.
   !            1 = sec, 60 = min, 3600 = hr, 24*3600 = days
   !  TINTS  :  Absolute time interval in units of TSCALE
   !  NTICMX :  Max. reasonable number of ticks to allow in the time range
   !  NTICKS :  Number of ticks in list of ticks to choose from
   !  TICKS  :  List of ticks from which the current tick was chosen
   !  NSUBS  :  List of number of minor ticks/major tick to choose NSUB from
   !  ITICK  :  Index of chosen tick in list TICKS
   !  AXIS   :  'X' or 'Y' axis
   !  DOPARA :  Labels parallel or perpendicular to axis
   !  STR    :  A typical formatted string used for checking overwrite
   ! Input/output:
   !  TICK   :  Current major tick interval in units of TSCALE. May be
   !            made larger if possible if overwrite likely.
   !  NSUB   :  Number of minor ticks between major ticks.
   !
   ! 10-Jun-1993 - New routine [nebk]
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer :: ntick
   double precision :: lens, lenx, leny

   !------ end of declarations -- execution starts hereafter  ------

   call pglen( 4, str, lenx, leny )
   lens = lenx
   if( (dopara .and. axis == 'Y') .or.                                  &
       (.not.dopara .and. axis == 'X') ) then
      lens = leny
   end if

   if( tscale == 1 .or. tscale == 60 .or.                               &
       (tscale == 3600 .and. doday) ) then

      !  Time in seconds or minutes, or in hours with a day field
      ntick = int(tints / tick)
      if( (itick < nticks)  .and.                                       &
          ((dopara .and. (lens/tscale) > 0.9d0*tick) .or.               &
          (ntick > nticmx)) ) then
         if( ticks(itick+1) < tints ) then
            nsub = nsubs(itick+1)
            tick = ticks(itick+1)
         end if
      end if
   else

      !  Time in hours and no day field or time in days
      ntick = int(tints / tick)
      if( (dopara .and. (lens/tscale) > 0.9d0*tick) .or.                &
          (ntick > nticmx) ) then
         if( itick < nticks ) then
            if( ticks(itick+1)*10**(npl-1) < tints ) then
               nsub = nsubs(itick+1)
               tick = ticks(itick+1) * 10**(npl-1)
            end if
         else
            if( ticks(1)*10**npl < tints ) then
               nsub = nsubs(1)
               tick = ticks(1) * 10**npl
            end if
         end if
      end if
   end if

end subroutine
