! PGTBX2 -- Support routine for PGTBOX

subroutine PGTBX2( tock, nticks, ticks, nsubs, tick, nsub, itick )

   integer :: nticks, nsubs(nticks), nsub, itick
   double precision :: tock, ticks(nticks), tick

   ! Find the nearest tick in a list to a given value.
   !
   ! This is a support routine for PGTBOX and should not be called
   ! by the user.
   !
   ! Input:
   !  TOCK   :  Try to find the nearest tick in the list to TOCK
   !  NTICKS :  Number of ticks in list
   !  TICKS  :  List of ticks
   !  NSUBS  :  List of number of minor ticks between ticks to go with TICKS
   ! Output:
   !  TICK   :  The selected tick
   !  ITICK  :  The index of the selected tick from the list TICKS
   ! Input/output
   !  NSUB   :  Number of minor ticks between major ticks. If 0 on input
   !            will be set here.
   !
   ! 10-Jun-1993 - New routine [nebk]
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer :: i, nsubd
   double precision :: dmin, diff

   !------ end of declarations -- execution starts hereafter  ------

   nsubd = nsub
   dmin = 1.0d30
   do i = 1, nticks
      diff = abs(tock - ticks(i))
      if( diff < dmin ) then
         tick = ticks(i)
         if( nsubd == 0 ) nsub = nsubs(i)
         itick = i

         dmin = diff
      end if
   end do

end subroutine
