! PGSWIN -- Set window

subroutine PGSWIN( x1, x2, y1, y2 )

   double precision, intent(in) :: x1, x2, y1, y2

   ! Change the window in world coordinate space that is to be mapped on
   ! to the viewport.  Usually PGSWIN is called automatically by PGENV,
   ! but it may be called directly by the user.
   !
   ! Arguments:
   !  X1     (input)  : the x-coordinate of the bottom left corner
   !                    of the viewport.
   !  X2     (input)  : the x-coordinate of the top right corner
   !                    of the viewport (note X2 may be less than X1).
   !  Y1     (input)  : the y-coordinate of the bottom left corner
   !                    of the viewport.
   !  Y2     (input)  : the y-coordinate of the top right corner
   !                    of the viewport (note Y2 may be less than Y1).
   !--
   ! 15-Nov-1995 - Check arguments to prevent divide-by-zero [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   ! If invalid arguments are specified, issue warning and leave window
   ! unchanged.
   if( x1 == x2 ) then
      call grwarn('invalid x limits in PGSWIN: X1 = X2.')
   else if( y1 == y2 ) then
      call grwarn('invalid y limits in PGSWIN: Y1 = Y2.')
   else
      pgxblc(pgid) = x1
      pgxtrc(pgid) = x2
      pgyblc(pgid) = y1
      pgytrc(pgid) = y2
      call pgvw
   end if

end subroutine
