! PGSVP -- Set viewport (normalized device coordinates)

subroutine PGSVP( xleft, xright, ybot, ytop )

   double precision :: xleft, xright, ybot, ytop

   ! Change the size and position of the viewport, specifying the viewport
   ! in normalized device coordinates.  Normalized device coordinates run
   ! from 0 to 1 in each dimension. The viewport is the rectangle on the
   ! view surface "through" which one views the graph.  All the PG routines
   ! which plot lines etc. plot them within the viewport, and lines are
   ! truncated at the edge of the viewport (except for axes, labels etc
   ! drawn with PGBOX or PGLAB).  The region of world space (the coordinate
   ! space of the graph) which is visible through the viewport is specified
   ! by a call to PGSWIN.  It is legal to request a viewport larger than the
   ! view surface; only the part which appears on the view surface will be
   ! plotted.
   !
   ! Arguments:
   !  XLEFT  (input)  : x-coordinate of left hand edge of viewport, in NDC.
   !  XRIGHT (input)  : x-coordinate of right hand edge of viewport,
   !                    in NDC.
   !  YBOT   (input)  : y-coordinate of bottom edge of viewport, in NDC.
   !  YTOP   (input)  : y-coordinate of top  edge of viewport, in NDC.
   !--
   ! 13-Dec-1990 - Make errors non-fatal [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   ! 16-Apr-2020 - Modified to take into account suppression of panels [EC].
   !-----------------------------------------------------------------------

   double precision :: xs, ys

   !------ end of declarations -- execution starts hereafter  ------

   if( xleft >= xright .or. ybot >= ytop ) then
       call grwarn('PGSVP ignored: invalid arguments')
       return
   end if

   xs = grxmxa(grcide)/pgxpin(pgid)
   ys = grymxa(grcide)/pgypin(pgid)
   call pgvsiz( xleft*xs, xright*xs, ybot*ys, ytop*ys )

end subroutine
