! PGSTBG -- Set text background color index

subroutine pgstbg( tbci )

   integer :: tbci

   ! Set the Text Background Color Index for subsequent text. By default
   ! text does not obscure underlying graphics. If the text background
   ! color index is positive, however, text is opaque: the bounding box
   ! of the text is filled with the color specified by PGSTBG before
   ! drawing the text characters in the current color index set by PGSCI.
   ! Use color index 0 to erase underlying graphics before drawing text.
   !
   ! Argument:
   !  TBCI (input): the color index to be used for the background
   !                for subsequent text plotting:
   !                   TBCI < 0  => transparent (default)
   !                   TBCI >= 0 => text will be drawn on an opaque
   !                                background with color index TBCI.
   !--
   ! 16-Oct-1993 - New routine [TJP].
   !-----------------------------------------------------------------------

   if( tbci < 0 ) then
       pgtbci(pgid) = -1
   else
       pgtbci(pgid) = tbci
   end if

end subroutine
