! PGSLCT -- Select an open graphics device

subroutine PGSLCT( id )

   integer :: id

   ! Select one of the open graphics devices and direct subsequent
   ! plotting to it. The argument is the device identifier returned by
   ! PGOPEN when the device was opened. If the supplied argument is not a
   ! valid identifier of an open graphics device, a warning message is
   ! issued and the current selection is unchanged.
   !
   ! Arguments:
   !
   ! ID (input, integer): identifier of the device to be selected.
   !--
   ! 22-Dec-1995 - New routine [TJP].
   !-----------------------------------------------------------------------

   if( id < 1 .or. pgmaxd < id ) then
      call grwarn('PGSLCT: invalid argument')
   else if( pgdevs(id) /= 1 ) then
      call grwarn('PGSLCT: requested device is not open')
   else
      ! Select the new device
      pgid = id
      call grslct(pgid)
   end if

end subroutine
