! PGSITF -- Set image transfer function

subroutine PGSITF( itf )

   integer :: itf

   ! Set the Image Transfer Function for subsequent images drawn by
   ! PGIMAG, PGGRAY, or PGWEDG. The Image Transfer Function is used
   ! to map array values into the available range of color indices
   ! specified with routine PGSCIR or (for PGGRAY on some devices)
   ! into dot density.
   !
   ! Argument:
   !  ITF    (input)  : type of transfer function:
   !                      ITF = 0 : linear
   !                      ITF = 1 : logarithmic
   !                      ITF = 2 : square-root
   !--
   ! 15-Sep-1994 - New routine [TJP].
   !-----------------------------------------------------------------------

   if( itf < 0 .or. 2 < itf ) then
       pgitf(pgid) = 0
       call grwarn('PGSITF: argument must be 0, 1, or 2')
   else
       pgitf(pgid) = itf
   end if

end subroutine
