! PGSHS -- Set hatching style

subroutine PGSHS( angle, sepn, phase )

   double precision :: angle, sepn, phase

   ! Set the style to be used for hatching (fill area with fill-style 3).
   ! The default style is ANGLE=45.0, SEPN=1.0, PHASE=0.0.
   !
   ! Arguments:
   !  ANGLE  (input)  : the angle the hatch lines make with the
   !                    horizontal, in degrees, increasing
   !                    counterclockwise (this is an angle on the
   !                    view surface, not in world-coordinate space).
   !  SEPN   (input)  : the spacing of the hatch lines. The unit spacing
   !                    is 1 percent of the smaller of the height or
   !                    width of the view surface. This should not be
   !                    zero.
   !  PHASE  (input)  : a real number between 0 and 1; the hatch lines
   !                    are displaced by this fraction of SEPN from a
   !                    fixed reference.  Adjacent regions hatched with the
   !                    same PHASE have contiguous hatch lines. To hatch
   !                    a region with alternating lines of two colors,
   !                    fill the area twice, with PHASE=0.0 for one color
   !                    and PHASE=0.5 for the other color.
   !--
   ! 26-Feb-1995 - New routine [TJP].
   ! 12-Feb-1996 - Check for zero spacing [TJP].
   !-----------------------------------------------------------------------

   pghsa(pgid) = angle
   if( sepn == 0.0d0 ) then
      call grwarn('PGSHS: zero hatch line spacing requested')
      pghss(pgid) = 1.0d0
   else
      pghss(pgid) = sepn
   end if
   if( phase < 0.0d0 .or. 1.0d0 < phase ) then
      call grwarn('PGSHS: hatching phase must be in (0.,1.)')
   end if
   pghsp(pgid) = phase

end subroutine
