! PGSHLS -- Set color representation using HLS system

subroutine PGSHLS( ci, ch, cl, cs )

   integer          :: ci
   double precision :: ch, cl, cs

   ! Set color representation: i.e., define the color to be
   ! associated with a color index.  This routine is equivalent to
   ! PGSCR, but the color is defined in the Hue-Lightness-Saturation
   ! model instead of the Red-Green-Blue model. Hue is represented
   ! by an angle in degrees, with red at 120, green at 240,
   ! and blue at 0 (or 360). Lightness ranges from 0.0 to 1.0, with black
   ! at lightness 0.0 and white at lightness 1.0. Saturation ranges from
   ! 0.0 (gray) to 1.0 (pure color). Hue is irrelevant when saturation
   ! is 0.0.
   !
   ! Examples:           H     L     S        R     G     B
   !     black          any   0.0   0.0      0.0   0.0   0.0
   !     white          any   1.0   0.0      1.0   1.0   1.0
   !     medium gray    any   0.5   0.0      0.5   0.5   0.5
   !     red            120   0.5   1.0      1.0   0.0   0.0
   !     yellow         180   0.5   1.0      1.0   1.0   0.0
   !     pink           120   0.7   0.8      0.94  0.46  0.46
   !
   ! Reference: SIGGRAPH Status Report of the Graphic Standards Planning
   ! Committee, Computer Graphics, Vol.13, No.3, Association for
   ! Computing Machinery, New York, NY, 1979. See also: J. D. Foley et al,
   ! ``Computer Graphics: Principles and Practice'', second edition,
   ! Addison-Wesley, 1990, section 13.3.5.
   !
   ! Argument:
   !  CI     (input)  : the color index to be defined, in the range 0-max.
   !                    If the color index greater than the device
   !                    maximum is specified, the call is ignored. Color
   !                    index 0 applies to the background color.
   !  CH     (input)  : hue, in range 0.0 to 360.0.
   !  CL     (input)  : lightness, in range 0.0 to 1.0.
   !  CS     (input)  : saturation, in range 0.0 to 1.0.
   !--
   !  9-May-1988 - New routine [TJP].
   !-----------------------------------------------------------------------

   double precision :: cr, cg, cb

   !------ end of declarations -- execution starts hereafter  ------

   call grxrgb( ch, cl, cs, cr, cg, cb )
   call grscr( ci, cr, cg, cb )

end subroutine
