! PGSFS -- Set fill-area style

subroutine PGSFS( fs )

   integer :: fs

   ! Set the Fill-Area Style attribute for subsequent area-fill by
   ! PGPOLY, PGRECT, or PGCIRC.  Four different styles are available:
   ! solid (fill polygon with solid color of the current color-index),
   ! outline (draw outline of polygon only, using current line attributes),
   ! hatched (shade interior of polygon with parallel lines, using
   ! current line attributes), or cross-hatched. The orientation and
   ! spacing of hatch lines can be specified with routine PGSHS (set
   ! hatch style).
   !
   ! Argument:
   !  FS     (input)  : the fill-area style to be used for subsequent
   !                    plotting:
   !                      FS = 1 => solid (default)
   !                      FS = 2 => outline
   !                      FS = 3 => hatched
   !                      FS = 4 => cross-hatched
   !                    Other values give an error message and are
   !                    treated as 2.
   !--
   ! 21-Oct-1985 - New routine [TJP].
   ! 17-Dec-1990 - Pass to GR level [TJP].
   !  6-Mar-1995 - Add styles 3 and 4 [TJP].
   !-----------------------------------------------------------------------

   if( fs < 1 .or. 4 < fs ) then
      call grwarn('illegal fill-area style requested')
      pgfas(pgid) = 2
   else
      pgfas(pgid) = fs
   end if

end subroutine
