! PGSCIR -- Set color index range

subroutine PGSCIR( icilo, icihi )

   integer :: icilo, icihi

   ! Set the color index range to be used for producing images with PGIMAG.
   ! If the range is not all within the range supported by the device, a
   ! smaller range will be used. The number of different colors available
   ! for images is ICIHI-ICILO+1.
   !
   ! Arguments:
   !  ICILO  (input)  : the lowest color index to use for images
   !  ICIHI  (input)  : the highest color index to use for images
   !--
   ! 17-Mar-1994 : New routine [AFT/TJP].
   !---------------------------------------------------------------------

   integer :: ic1, ic2

   !------ end of declarations -- execution starts hereafter  ------

   call grqcol(ic1,ic2)
   pgmnci(pgid) = min(ic2,max(ic1,icilo))
   pgmxci(pgid) = min(ic2,max(ic1,icihi))

end subroutine
