! PGSCH -- Set character height

subroutine PGSCH( size )

   double precision, intent(in) :: size

   ! Set the character size attribute. The size affects all text and graph
   ! markers drawn later in the program. The default character size is 1.0,
   ! corresponding to a character height about 1/40th of the smaller
   ! dimension of the view surface.
   ! Changing the character size also scales the length of tick marks drawn
   ! by PGBOX and terminals drawn by PGERRX and PGERRY. Same for the arrow
   ! head drawn by PGARRO.
   !
   ! Argument:
   !  SIZE   (input) : character size (dimensionless multiple of the
   !                   the default size).
   !--
   !  1-Mar-1983
   ! 30-Jun-2010 - Simpler test in order to have simpler formula for PGYSP
   !               [EC].
   ! 18-Aug-2018 - Test on EPS or PDF is removed, because all devices need
   !               to know the value of ps_font_size and ps_char_height [EC].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   ! 16-Apr-2020 - Modified to take into account suppression of panels [EC].
   !-----------------------------------------------------------------------

   double precision :: y_space

   !------ end of declarations -- execution starts hereafter  ------

   if( size <= 0 ) then
      print *
      print *, "Internal error:"
      print *, "      PGSCH: size must be strictly greater than zero!"
      pause "for debugging purpose only"
      stop
   end if

   ! Comparison is made on physical size (device units)
   if( grxmxa(grcide) > grymxa(grcide) ) then
      ! Landscape format
      y_space = size*(grymxa(grcide)/40.0d0)
   else
      ! Portrait format
      y_space = size*(grxmxa(grcide)/40.0d0)
   end if

   ! Font size (needed by all devices)
   ps_font_size = y_space * 0.9075d0
   ! saving character height for computing approximated BBox in EPS
   ps_char_height = y_space * 0.646d0

   ! Character scaling factor
   grcfac(grcide) = y_space/13.0d0

   ! Character X spacing (device units)
   pgxsp(pgid) = y_space*10.0d0/13.0d0

   ! Character Y spacing (device units)
   pgysp(pgid) = y_space

   ! Character height
   pgchsz(pgid) = size

end subroutine
