! PGSAH -- Set arrow-head style

subroutine PGSAH( fs, angle, barb )

      integer          :: fs
      double precision :: angle, barb

   ! Set the style to be used for arrowheads drawn with routine PGARRO.
   !
   ! Argument:
   !  FS     (input)  : FS = 1 => filled; FS = 2 => outline.
   !                    Other values are treated as 2. Default 1.
   !  ANGLE  (input)  : the acute angle of the arrow point, in degrees;
   !                    angles in the range 20.0 to 90.0 give reasonable
   !                    results. Default 45.0.
   !  BARB   (input)  : the fraction of the triangular arrow-head that
   !                    is cut away from the back. 0.0 gives a triangular
   !                    wedge arrow-head; 1.0 gives an open >. Values 0.3
   !                    to 0.7 give reasonable results. Default 0.3.
   !--
   ! 13-Oct-1992 - New routine [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   pgahs(pgid) = fs
   if( pgahs(pgid) /= 1 ) pgahs(pgid) = 2
   pgaha(pgid) = angle
   pgahv(pgid) = barb

end subroutine
