! PGRNGE -- Choose axis limits

subroutine PGRNGE( x1, x2, xlo, xhi )

   double precision :: x1, x2, xlo, xhi

   ! Choose plotting limits XLO and XHI which encompass the data
   ! range X1 to X2.
   !
   ! Arguments:
   !  X1, X2 (input)  : the data range (X1<X2), ie, the min and max values
   !                    to be plotted.
   !  XLO, XHI (output) : suitable values to use as the extremes of a graph
   !                    axis (XLO <= X1, XHI >= X2).
   !--
   ! 10-Nov-1985 - New routine [TJP].
   !-----------------------------------------------------------------------

   xlo = x1 - 0.1d0*(x2-x1)
   xhi = x2 + 0.1d0*(x2-x1)
   if( xlo < 0.0d0 .and. x1 >= 0.0d0 ) xlo = 0.0d0
   if( xhi > 0.0d0 .and. x2 <= 0.0d0 ) xhi = 0.0d0

end subroutine
