! PGRND -- Find the smallest `round' number greater than x

double precision function PGRND( x, nsub )

   double precision, intent(in) :: x
   integer                      :: nsub

   ! Routine to find the smallest "round" number larger than x, a
   ! "round" number being 1, 2 or 5 times a power of 10. If X is negative,
   ! PGRND(X) = -PGRND(ABS(X)). eg PGRND(8.7) = 10.0,
   ! PGRND(-0.4) = -0.5.  If X is zero, the value returned is zero.
   ! This routine is used by PGBOX for choosing tick intervals.
   !
   ! Returns:
   !  PGRND         : the "round" number.
   ! Arguments:
   !  X      (input)  : the number to be rounded.
   !  NSUB   (output) : a suitable number of subdivisions for
   !                    subdividing the "nice" number: 2 or 5.
   !--
   !  6-Sep-1989 - Changes for standard Fortran-77 [TJP].
   !  2-Dec-1991 - Fix for bug found on Fujitsu [TJP].
   !  7-May-2007 - Correction for ILOG is removed [É. Canot]
   !               Correction for test about FRAC [É. Canot]
   ! 29-Feb-2020 - Use now double precision instead of single precision [EC].
   !-----------------------------------------------------------------------

   integer :: ilog
   double precision :: frac, pwr, xlog, xx

   double precision :: nice(3)
   data nice/ 2.0d0, 5.0d0, 10.0d0 /

   !------ end of declarations -- execution starts hereafter  ------

   if( x == 0.0d0 ) then
      pgrnd = 0.0d0
      nsub = 2
      return
   end if

   xx = abs(x)
   xlog = log10(xx)
   ilog = nint(xlog)
   pwr = 10.0d0**ilog
   frac = xx/pwr

   nsub = 5
   if( frac <= 0.5d0 ) then
      pgrnd = 0.5d0*pwr
   else if( frac <= 1.0d0 ) then
      pgrnd = pwr
   else if( frac <= 2.0d0 ) then
      pgrnd = 2.0d0*pwr
      nsub = 2
   else
      pgrnd = 5.0d0*pwr
   end if

end function
