! PGQVSZ -- Inquire size of view surface

subroutine PGQVSZ( units, x1, x2, y1, y2 )

   integer,          intent(in)  :: units
   double precision, intent(out) :: x1, x2, y1, y2
   !------ API end ------

   ! This routine returns the dimensions of the view surface (the maximum
   ! plottable area) of the currently selected graphics device, in
   ! a variety of units. The size of the view surface is device-dependent
   ! and is established when the graphics device is opened. On some
   ! devices, it can be changed by calling PGPAP before starting a new
   ! page with PGPAGE. On some devices, the size can be changed (e.g.,
   ! by a workstation window manager) outside MFPLOT, and MFPLOT detects
   ! the change when PGPAGE is used. Call this routine after PGPAGE to
   ! find the current size.
   !
   ! Note: the width and the height of the view surface in normalized
   !       device coordinates are both always equal to 1.0.
   !
   ! Arguments:
   !  UNITS  (input)  : output in normalized device coords [0]
   !                              inches                   [1]
   !                              mm                       [2]
   !                              device units (pixels)    [3]
   !  X1     (output) : always returns 0.0
   !  X2     (output) : width of view surface
   !  Y1     (output) : always returns 0.0
   !  Y2     (output) : height of view surface
   !--
   ! 28-Aug-1992 - New routine [Neil Killeen].
   !  2-Dec-1992 - Changed to avoid resetting the viewport [TJP].
   ! 26-Feb-1997 - Revised description [TJP].
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   ! 16-Apr-2020 - Modified to take into account suppression of panels;
   !               Simplified algorithm.
   !-----------------------------------------------------------------------

   x1 = 0.0d0
   y1 = 0.0d0

   if( units == 0 ) then
      x2 = 1.0d0
      y2 = 1.0d0
   else if( units == 1 ) then
      x2 = grxmxa(grcide)/pgxpin(pgid)
      y2 = grymxa(grcide)/pgypin(pgid)
   else if( units == 2 ) then
      x2 = grxmxa(grcide)/(pgxpin(pgid)/25.4d0)
      y2 = grymxa(grcide)/(pgypin(pgid)/25.4d0)
   else if( units == 3 ) then
      x2 = grxmxa(grcide)
      y2 = grymxa(grcide)
   else
      call grwarn( "PGQVSZ: Illegal value for parameter UNITS" )
      x2 = 1.0d0
      y2 = 1.0d0
   end if

end subroutine
